/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gs2;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.realm.ldap.SimpleDirContextFactoryBuilder;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.mechanism.gssapi.GSSCredentialSecurityFactory;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.gs2.Gs2;
import org.wildfly.security.sasl.gs2.Gs2SaslClient;
import org.wildfly.security.sasl.gs2.Gs2SaslClientFactory;
import org.wildfly.security.sasl.gs2.Gs2SaslServerFactory;
import org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider;
import org.wildfly.security.sasl.gssapi.GssapiTestSuite;
import org.wildfly.security.sasl.gssapi.JaasUtil;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;
import org.wildfly.security.sasl.util.ChannelBindingSaslClientFactory;
import org.wildfly.security.sasl.util.PropertiesSaslClientFactory;
import org.wildfly.security.sasl.util.ProtocolSaslClientFactory;
import org.wildfly.security.sasl.util.ServerNameSaslClientFactory;

public class Gs2SuiteChild {
    private static final String TEST_SERVER_1 = "test_server_1";
    private static Subject clientSubject;
    private static Subject serverSubject;
    private SaslServer saslServer;
    private SaslClient saslClient;
    private static final Provider provider;

    @BeforeClass
    public static void registerProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removeProvider() {
        Security.removeProvider(provider.getName());
    }

    @BeforeClass
    public static void init() throws LoginException {
        clientSubject = JaasUtil.loginClient();
        serverSubject = JaasUtil.loginServer(GssapiTestSuite.serverKeyTab, false);
    }

    @Test
    public void testChannelBindingIndirect_Server() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.saslServer = this.getIndirectSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, props, null, null);
        Assert.assertEquals((Object)"GS2-KRB5", (Object)this.saslServer.getMechanismName());
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        this.saslServer = this.getIndirectSaslServer("GS2-KRB5-PLUS", "sasl", TEST_SERVER_1, props, "tls-unique", new byte[0]);
        Assert.assertEquals((Object)"GS2-KRB5-PLUS", (Object)this.saslServer.getMechanismName());
        this.saslServer = this.getIndirectSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, props, null, null);
        Assert.assertNull((Object)this.saslServer);
    }

    @Test
    public void testChannelBindingDirect_Server() {
        SaslServerFactory factory = SaslTestUtil.obtainSaslServerFactory(Gs2SaslServerFactory.class);
        Assert.assertNotNull((String)"SaslServerFactory not registered", (Object)factory);
        HashMap<String, String> props = new HashMap<String, String>();
        String[] mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"GS2-KRB5", "GS2-KRB5-PLUS"}, (String[])mechanisms);
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"GS2-KRB5-PLUS"}, (String[])mechanisms);
    }

    @Test
    public void testChannelBindingIndirect_Client() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.saslClient = this.getIndirectSaslClient(new String[]{"GS2-KRB5"}, null, "sasl", TEST_SERVER_1, props, null, null);
        Assert.assertEquals(Gs2SaslClient.class, this.saslClient.getClass());
        Assert.assertEquals((Object)"GS2-KRB5", (Object)this.saslClient.getMechanismName());
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        this.saslClient = this.getIndirectSaslClient(new String[]{"GS2-DT4PIK22T6A", "GS2-KRB5"}, null, "sasl", TEST_SERVER_1, props, null, null);
        Assert.assertNull((Object)this.saslClient);
        this.saslClient = this.getIndirectSaslClient(new String[]{"GS2-DT4PIK22T6A-PLUS", "GS2-KRB5-PLUS"}, null, "sasl", TEST_SERVER_1, props, "tls-unique", new byte[0]);
        Assert.assertEquals(Gs2SaslClient.class, this.saslClient.getClass());
        Assert.assertEquals((Object)"GS2-KRB5-PLUS", (Object)this.saslClient.getMechanismName());
    }

    @Test
    public void testChannelBindingDirect_Client() {
        SaslClientFactory factory = SaslTestUtil.obtainSaslClientFactory(Gs2SaslClientFactory.class);
        Assert.assertNotNull((String)"SaslClientFactory not registered", (Object)factory);
        HashMap<String, String> props = new HashMap<String, String>();
        String[] mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"GS2-KRB5", "GS2-KRB5-PLUS"}, (String[])mechanisms);
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"GS2-KRB5-PLUS"}, (String[])mechanisms);
    }

    @Test
    public void testKrb5AuthenticationWithoutChannelBinding() throws Exception {
        this.saslServer = this.getSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslServer);
        Assert.assertEquals((Object)"GS2-KRB5", (Object)this.saslServer.getMechanismName());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5"}, null, "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslClient);
        Assert.assertTrue((boolean)(this.saslClient instanceof Gs2SaslClient));
        Assert.assertTrue((boolean)this.saslClient.hasInitialResponse());
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        byte[] message = this.evaluateChallenge(new byte[0]);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        message = this.evaluateResponse(message);
        Assert.assertTrue((boolean)this.saslServer.isComplete());
        Assert.assertNotNull((Object)message);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        message = this.evaluateChallenge(message);
        Assert.assertTrue((boolean)this.saslClient.isComplete());
        Assert.assertNull((Object)message);
        Assert.assertEquals((Object)"jduke@WILDFLY.ORG", (Object)this.saslServer.getAuthorizationID());
    }

    @Test
    public void testKrb5AuthenticationWithChannelBinding() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        this.saslServer = this.getSaslServer("GS2-KRB5-PLUS", "sasl", TEST_SERVER_1, props, "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslServer);
        Assert.assertEquals((Object)"GS2-KRB5-PLUS", (Object)this.saslServer.getMechanismName());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5-PLUS"}, "jduke@WILDFLY.ORG", "sasl", TEST_SERVER_1, props, "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslClient);
        Assert.assertTrue((boolean)(this.saslClient instanceof Gs2SaslClient));
        Assert.assertTrue((boolean)this.saslClient.hasInitialResponse());
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        byte[] message = this.evaluateChallenge(new byte[0]);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        message = this.evaluateResponse(message);
        Assert.assertTrue((boolean)this.saslServer.isComplete());
        Assert.assertNotNull((Object)message);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        message = this.evaluateChallenge(message);
        Assert.assertTrue((boolean)this.saslClient.isComplete());
        Assert.assertNull((Object)message);
        Assert.assertEquals((Object)"jduke@WILDFLY.ORG", (Object)this.saslServer.getAuthorizationID());
    }

    @Test
    public void testKrb5AuthenticationWithCredentialPassedInForClientAndServer() throws Exception {
        this.saslServer = this.getSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null, true);
        Assert.assertNotNull((Object)this.saslServer);
        Assert.assertEquals((Object)"GS2-KRB5", (Object)this.saslServer.getMechanismName());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5"}, "jduke@WILDFLY.ORG", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null, true);
        Assert.assertNotNull((Object)this.saslClient);
        Assert.assertTrue((boolean)(this.saslClient instanceof Gs2SaslClient));
        Assert.assertTrue((boolean)this.saslClient.hasInitialResponse());
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        byte[] message = this.saslClient.evaluateChallenge(new byte[0]);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        message = this.saslServer.evaluateResponse(message);
        Assert.assertTrue((boolean)this.saslServer.isComplete());
        Assert.assertNotNull((Object)message);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        message = this.saslClient.evaluateChallenge(message);
        Assert.assertTrue((boolean)this.saslClient.isComplete());
        Assert.assertNull((Object)message);
        Assert.assertEquals((Object)"jduke@WILDFLY.ORG", (Object)this.saslServer.getAuthorizationID());
    }

    @Test
    public void testKrb5AuthenticationUnboundedServerName() throws Exception {
        this.saslServer = this.getSaslServer("GS2-KRB5", "sasl", null, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslServer);
        Assert.assertEquals((Object)"GS2-KRB5", (Object)this.saslServer.getMechanismName());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5"}, null, "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslClient);
        Assert.assertTrue((boolean)(this.saslClient instanceof Gs2SaslClient));
        Assert.assertTrue((boolean)this.saslClient.hasInitialResponse());
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        byte[] message = this.evaluateChallenge(new byte[0]);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        message = this.evaluateResponse(message);
        Assert.assertTrue((boolean)this.saslServer.isComplete());
        Assert.assertNotNull((Object)message);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        message = this.evaluateChallenge(message);
        Assert.assertTrue((boolean)this.saslClient.isComplete());
        Assert.assertNull((Object)message);
        Assert.assertEquals((Object)"jduke@WILDFLY.ORG", (Object)this.saslServer.getAuthorizationID());
        Assert.assertEquals((String)"Bound server name", (Object)TEST_SERVER_1, (Object)this.saslServer.getNegotiatedProperty("javax.security.sasl.bound.server.name"));
    }

    @Test
    public void testChannelBindingNotUsedByClientSupportedByServer() throws Exception {
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5"}, null, "sasl", TEST_SERVER_1, Collections.emptyMap(), "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslClient);
        this.saslServer = this.getSaslServer("GS2-KRB5-PLUS", "sasl", TEST_SERVER_1, Collections.emptyMap(), "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslServer);
        byte[] message = this.evaluateChallenge(new byte[0]);
        try {
            message = this.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testChannelBindingUsedByClientUnsupportedByServer() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5-PLUS"}, null, "sasl", TEST_SERVER_1, props, "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslClient);
        this.saslServer = this.getSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslServer);
        byte[] message = this.evaluateChallenge(new byte[0]);
        try {
            message = this.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testChannelBindingUnsupportedByClientSupportedByServer() throws Exception {
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5"}, null, "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslClient);
        this.saslServer = this.getSaslServer("GS2-KRB5-PLUS", "sasl", TEST_SERVER_1, Collections.emptyMap(), "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslServer);
        byte[] message = this.evaluateChallenge(new byte[0]);
        try {
            message = this.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testChannelBindingTypeMismatch() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5-PLUS"}, null, "sasl", TEST_SERVER_1, props, "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslClient);
        this.saslServer = this.getSaslServer("GS2-KRB5-PLUS", "sasl", TEST_SERVER_1, Collections.emptyMap(), "tls-unique-for-telnet", new byte[0]);
        Assert.assertNotNull((Object)this.saslServer);
        byte[] message = this.evaluateChallenge(new byte[0]);
        try {
            message = this.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testChannelBindingDataMismatch() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("wildfly.sasl.channel-binding-required", Boolean.toString(true));
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5-PLUS"}, null, "sasl", TEST_SERVER_1, props, "tls-unique", new byte[0]);
        Assert.assertNotNull((Object)this.saslClient);
        this.saslServer = this.getSaslServer("GS2-KRB5-PLUS", "sasl", TEST_SERVER_1, Collections.emptyMap(), "tls-unique", new byte[1]);
        Assert.assertNotNull((Object)this.saslServer);
        byte[] message = this.evaluateChallenge(new byte[0]);
        try {
            message = this.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testUnauthorizedAuthorizationId() throws Exception {
        this.saslServer = this.getSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslServer);
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5"}, "sasl/test_server_1@WILDFLY.ORG", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslClient);
        byte[] message = this.evaluateChallenge(new byte[0]);
        try {
            message = this.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testUnneededNonStdFlag() throws Exception {
        this.saslServer = this.getSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslServer);
        this.saslClient = this.getSaslClient(new String[]{"GS2-KRB5"}, null, "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslClient);
        byte[] origMessage = this.evaluateChallenge(new byte[0]);
        Assert.assertFalse((boolean)this.saslClient.isComplete());
        Assert.assertFalse((boolean)this.saslServer.isComplete());
        byte[] message = new byte[origMessage.length + 2];
        System.arraycopy(origMessage, 0, message, 2, origMessage.length);
        message[0] = 70;
        message[1] = 44;
        try {
            message = this.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidGs2Header() throws Exception {
        this.saslServer = this.getSaslServer("GS2-KRB5", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNotNull((Object)this.saslServer);
        try {
            byte[] message = this.evaluateResponse(new byte[]{98, 44, 44, 1, 0, 110, -126, 1, -13, 48, -126, 1, -17, -96, 3, 2, 1, 5, -95, 3, 2, 1, 14, -94, 7, 3, 5, 0, 32, 0, 0, 0, -93, -126, 1, 11, 97, -126, 1, 7, 48, -126, 1, 3, -96, 3, 2, 1, 5, -95, 13, 27, 11, 87, 73, 76, 68, 70, 76, 89, 46, 79, 82, 71, -94, 32, 48, 30, -96, 3, 2, 1, 0, -95, 23, 48, 21, 27, 4, 115, 97, 115, 108, 27, 13, 116, 101, 115, 116, 95, 115, 101, 114, 118, 101, 114, 95, 49, -93, -127, -54, 48, -127, -57, -96, 3, 2, 1, 16, -94, -127, -65, 4, -127, -68, 85, 26, 77, -98, -85, 110, 17, -61, 12, -36, 34, -105, 37, 126, 2, 74, -98, 47, -23, -108, 57, 2, -4, 110, -71, -79, -99, 8, 71, 11, -90, -118, -23, -122, -115, 3, -105, 31, 52, -50, -104, 35, -7, -14, -102, -39, 110, 74, -17, 55, 78, 67, -52, 74, -59, 85, 40, 89, -8, -61, -109, -69, -126, 31, -100, 62, 37, 78, -20, 99, -24, -28, -54, 112, 34, 87, -4, 57, -46, 97, 118, 43, 103, -74, -39, -59, -16, -88, 8, -122, 81, 83, -103, 83, 49, 54, -20, -125, -110, 18, 26, 87, -22, -111, 71, 122, 110, 83, -33, -92, -94, 114, -92, -30, 114, 22, 46, 73, 38, 58, -117, -118, -23, -18, -91, -14, -42, 84, 37, -4, 90, 116, -77, -41, 93, 82, 54, -69, 114, 124, -82, -102, -50, -83, 17, 117, -86, 106, 50, 78, -122, 54, 57, -27, -89, -85, 125, -104, 110, -38, 75, -25, -85, 91, -77, -7, -68, 112, 87, -125, -28, 34, 71, -62, -34, -110, -122, -120, -86, -93, -41, 41, -34, 91, 88, -114, 112, 83, -92, -127, -54, 48, -127, -57, -96, 3, 2, 1, 16, -94, -127, -65, 4, -127, -68, -12, -3, 100, 43, -53, 16, 56, -68, 107, -81, 105, 26, 123, 115, 94, -94, 119, 36, 65, 109, 68, 26, -61, 22, -68, -68, 29, -36, -80, 80, -66, 24, 74, -7, -5, -43, 37, -75, 26, -33, 50, 89, 81, 125, 67, 64, 27, 104, 24, -42, 37, -19, 13, 65, 95, -25, -19, 23, 58, -42, -43, 88, -42, -1, 121, 87, -12, 17, 55, -116, 81, -107, -22, -56, 0, 99, -56, 56, 67, 57, -127, -3, 73, -56, -100, -74, -78, 27, 7, 58, -47, 23, -12, 20, 15, 65, -77, -36, 14, 122, -95, 45, -9, -116, 89, 87, 82, -117, -60, 22, 55, 104, 103, -71, -12, -45, -1, -44, 106, -117, 91, 83, -44, -60, 122, -100, -89, -65, 43, 107, -124, -57, -82, 113, 72, 77, -84, 121, -90, 57, -28, 90, 80, -33, 97, -62, 10, 124, 67, 97, 110, 87, 20, -78, -14, -9, 84, 64, 78, 28, -63, -78, -29, -93, 29, 111, -34, -128, 96, -53, -25, -84, -39, -44, 85, 96, 0, -35, 35, -100, -123, 7, -112, -26, -89, 14, 92, -28});
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testDisallowedMechanism() throws Exception {
        this.saslServer = this.getSaslServer("SPNEGO", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNull((Object)this.saslServer);
        this.saslClient = this.getSaslClient(new String[]{"SPNEGO", "SPNEGO-PLUS"}, "bsmith@WILDFLY.ORG", "sasl", TEST_SERVER_1, Collections.emptyMap(), null, null);
        Assert.assertNull((Object)this.saslClient);
    }

    @Test
    public void testGetSaslNameForMechanismOid() throws Exception {
        Assert.assertEquals((Object)"GS2-KRB5", (Object)Gs2.getSaslNameForMechanism((Oid)GSSCredentialSecurityFactory.KERBEROS_V5, (boolean)false));
        Assert.assertEquals((Object)"SPNEGO-PLUS", (Object)Gs2.getSaslNameForMechanism((Oid)GSSCredentialSecurityFactory.SPNEGO, (boolean)true));
        Assert.assertEquals((Object)"GS2-DT4PIK22T6A-PLUS", (Object)Gs2.getSaslNameForMechanism((Oid)new Oid("1.3.6.1.5.5.1.1"), (boolean)true));
    }

    @Test
    public void testGetMechanismForSaslName() throws Exception {
        Assert.assertEquals((Object)GSSCredentialSecurityFactory.KERBEROS_V5, (Object)Gs2.getMechanismForSaslName((GSSManager)GSSManager.getInstance(), (String)"GS2-KRB5-PLUS"));
        Assert.assertEquals((Object)GSSCredentialSecurityFactory.SPNEGO, (Object)Gs2.getMechanismForSaslName((GSSManager)GSSManager.getInstance(), (String)"SPNEGO"));
    }

    private SaslServer getIndirectSaslServer(final String mechanism, final String protocol, final String serverName, final Map<String, Object> props, final String bindingType, final byte[] bindingData) throws SaslException {
        try {
            return Subject.doAs(serverSubject, new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() throws SaslException {
                    IndirectCallbackHandler cbh = new IndirectCallbackHandler(bindingType, bindingData);
                    return Sasl.createSaslServer(mechanism, protocol, serverName, props, cbh);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private SaslServer getSaslServer(String mechanism, String protocol, String serverName, Map<String, Object> props, String bindingType, byte[] bindingData) throws SaslException {
        return this.getSaslServer(mechanism, protocol, serverName, props, bindingType, bindingData, false);
    }

    private SaslServer getSaslServer(String mechanism, String protocol, String serverName, Map<String, Object> props, String bindingType, byte[] bindingData, boolean passCredential) throws SaslException {
        GSSCredential credential = null;
        if (passCredential) {
            try {
                credential = Subject.doAs(serverSubject, new PrivilegedExceptionAction<GSSCredential>(){

                    @Override
                    public GSSCredential run() throws SaslException {
                        try {
                            return GSSManager.getInstance().createCredential(null, Integer.MAX_VALUE, GSSCredentialSecurityFactory.KERBEROS_V5, 2);
                        }
                        catch (GSSException e) {
                            throw new SaslException(e.getMessage());
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof SaslException) {
                    throw (SaslException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
        final SaslServerBuilder builder = new SaslServerBuilder(Gs2SaslServerFactory.class, mechanism).setDontAssertBuiltServer();
        ExceptionSupplier dirContextSupplier = () -> SimpleDirContextFactoryBuilder.builder().setProviderUrl(String.format("ldap://localhost:%d/", 11390)).setSecurityPrincipal("uid=Sasl_1,ou=Users,dc=wildfly,dc=org").setSecurityCredential("servicepwd").build().obtainDirContext(DirContextFactory.ReferralMode.IGNORE);
        ModifiableSecurityRealm securityRealm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(dirContextSupplier).setNameRewriter((NameRewriter)new RegexNameRewriter(Pattern.compile("(.*)@WILDFLY\\.ORG"), "$1", true)).identityMapping().setSearchDn("dc=wildfly,dc=org").searchRecursive().setRdnIdentifier("uid").build().build();
        String realmName = "ldapRealm";
        builder.addRealm("ldapRealm", (SecurityRealm)securityRealm);
        builder.setDefaultRealmName("ldapRealm");
        if (protocol != null) {
            builder.setProtocol(protocol);
        }
        if (serverName != null) {
            builder.setServerName(serverName);
        }
        if (props != null) {
            builder.setProperties(props);
        }
        if (bindingType != null || bindingData != null) {
            builder.setChannelBinding(bindingType, bindingData);
        }
        if (credential != null) {
            builder.setCredential((Credential)new GSSKerberosCredential(credential));
        }
        try {
            return Subject.doAs(serverSubject, new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() throws Exception {
                    return builder.build();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private SaslClient getIndirectSaslClient(final String[] mechanisms, final String authorizationId, final String protocol, final String serverName, final Map<String, Object> props, final String bindingType, final byte[] bindingData) throws SaslException {
        try {
            return Subject.doAs(clientSubject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    IndirectCallbackHandler cbh = new IndirectCallbackHandler(bindingType, bindingData);
                    return Sasl.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private SaslClient getSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, Object> props, String bindingType, byte[] bindingData) throws Exception {
        return this.getSaslClient(mechanisms, authorizationId, protocol, serverName, props, bindingType, bindingData, false);
    }

    private SaslClient getSaslClient(final String[] mechanisms, final String authorizationId, final String protocol, final String serverName, final Map<String, Object> props, String bindingType, byte[] bindingData, boolean passCredential) throws Exception {
        GSSCredential credential = null;
        if (passCredential) {
            try {
                credential = Subject.doAs(clientSubject, new PrivilegedExceptionAction<GSSCredential>(){

                    @Override
                    public GSSCredential run() throws SaslException {
                        try {
                            return GSSManager.getInstance().createCredential(null, Integer.MAX_VALUE, GSSCredentialSecurityFactory.KERBEROS_V5, 1);
                        }
                        catch (GSSException e) {
                            throw new SaslException(e.getMessage());
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof SaslException) {
                    throw (SaslException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
        final CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, authorizationId, credential);
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(Gs2SaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        if (bindingType != null || bindingData != null) {
            clientFactory = new ChannelBindingSaslClientFactory(clientFactory, bindingType, bindingData);
            Assert.assertNotNull((Object)clientFactory);
        }
        if (protocol != null) {
            clientFactory = new ProtocolSaslClientFactory(clientFactory, protocol);
            Assert.assertNotNull((Object)clientFactory);
        }
        if (serverName != null) {
            clientFactory = new ServerNameSaslClientFactory(clientFactory, serverName);
            Assert.assertNotNull((Object)clientFactory);
        }
        if (props != null) {
            clientFactory = new PropertiesSaslClientFactory(clientFactory, props);
            Assert.assertNotNull((Object)clientFactory);
        }
        final SaslClientFactory factory = clientFactory;
        try {
            return Subject.doAs(clientSubject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    return factory.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private CallbackHandler createClientCallbackHandler(String[] mechanisms, String authorizationId, GSSCredential credential) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useAuthorizationName(authorizationId).useGSSCredential(credential).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanisms(mechanisms)));
        return ClientUtils.getCallbackHandler(new URI("remote://localhost"), context);
    }

    private byte[] evaluateResponse(final byte[] response) throws SaslException {
        try {
            return Subject.doAs(serverSubject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return Gs2SuiteChild.this.saslServer.evaluateResponse(response);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private byte[] evaluateChallenge(final byte[] challenge) throws SaslException {
        try {
            return Subject.doAs(clientSubject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return Gs2SuiteChild.this.saslClient.evaluateChallenge(challenge);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SaslException) {
                throw (SaslException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    static {
        provider = WildFlyElytronSaslGs2Provider.getInstance();
    }

    private static class IndirectCallbackHandler
    implements CallbackHandler {
        private final String bindingType;
        private final byte[] bindingData;

        private IndirectCallbackHandler(String bindingType, byte[] bindingData) {
            this.bindingType = bindingType;
            this.bindingData = bindingData;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof ChannelBindingCallback)) continue;
                ChannelBindingCallback channelBindingCallback = (ChannelBindingCallback)callback;
                channelBindingCallback.setBindingType(this.bindingType);
                channelBindingCallback.setBindingData(this.bindingData);
            }
        }
    }
}

