/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.basic;

import java.util.Collections;
import java.util.List;
import mockit.integration.junit4.JMockit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.impl.AbstractBaseHttpTest;

@RunWith(value=JMockit.class)
public class BasicAuthenticationMechanismTest
extends AbstractBaseHttpTest {
    public void testBasic(String username, String realm, String password, String authorization, boolean wrongPassword) throws Exception {
        HttpServerAuthenticationMechanism mechanism = this.basicFactory.createAuthenticationMechanism("BASIC", Collections.singletonMap(HttpConstants.CONFIG_REALM, realm), this.getCallbackHandler(username, realm, password));
        AbstractBaseHttpTest.TestingHttpServerRequest request = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        mechanism.evaluateRequest((HttpServerRequest)request);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request.getResult()));
        AbstractBaseHttpTest.TestingHttpServerResponse response = request.getResponse();
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)("Basic realm=\"" + realm + "\""), (Object)response.getAuthenticateHeader());
        request = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{authorization});
        mechanism.evaluateRequest((HttpServerRequest)request);
        if (wrongPassword) {
            response = request.getResponse();
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        } else {
            Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request.getResult()));
        }
    }

    private void testBasic(String username, String realm, String password, String authorization) throws Exception {
        this.testBasic(username, realm, password, authorization, false);
    }

    @Test
    public void testBasicRFC7617Examples() throws Exception {
        this.testBasic("Aladdin", "WallyWorld", "open sesame", "Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.testBasic("test", "foo", "123\u00a3", "Basic dGVzdDoxMjPCow==");
        this.testBasic("Aladdin", "WallyWorld", "open sesame", "basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.testBasic("test", "foo", "123\u00a3", "BASIC dGVzdDoxMjPCow==");
        this.testBasic("Aladdin", "WallyWorld", "open sesame", "basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.testBasic("Aladdin", "WallyWorld", "sesame", "basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==", true);
    }

    public void testStatefulBasic(String username, String realm, String password, String authorization) throws Exception {
        HttpServerAuthenticationMechanism mechanism = this.statefulBasicFactory.createAuthenticationMechanism("STATEFUL_BASIC", Collections.singletonMap(HttpConstants.CONFIG_REALM, realm), this.getCallbackHandler(username, realm, password));
        AbstractBaseHttpTest.TestingHttpServerRequest request = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        mechanism.evaluateRequest((HttpServerRequest)request);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request.getResult()));
        AbstractBaseHttpTest.TestingHttpServerResponse response = request.getResponse();
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)("Basic realm=\"" + realm + "\""), (Object)response.getAuthenticateHeader());
        request = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{authorization});
        mechanism.evaluateRequest((HttpServerRequest)request);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request.getResult()));
        response = request.getResponse();
        List<HttpServerCookie> cookies = response.getCookies();
        Assert.assertNotNull(cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"ELYTRON_AUTH_SESSION", (Object)cookies.get(0).getName());
        request = new AbstractBaseHttpTest.TestingHttpServerRequest(null, null, cookies);
        mechanism.evaluateRequest((HttpServerRequest)request);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request.getResult()));
    }

    @Test
    public void testStatefulBasicRFC7617Examples() throws Exception {
        this.testStatefulBasic("Aladdin", "WallyWorld", "open sesame", "Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.testStatefulBasic("test", "foo", "123\u00a3", "Basic dGVzdDoxMjPCow==");
        this.testStatefulBasic("Aladdin", "WallyWorld", "open sesame", "basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.testStatefulBasic("test", "foo", "123\u00a3", "BASIC dGVzdDoxMjPCow==");
    }
}

