/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;

public class IdentityCredentialsTest {
    @Test
    public void testLooseMatches() throws GeneralSecurityException {
        IdentityCredentials credentials = IdentityCredentials.NONE;
        PasswordCredential credential1 = new PasswordCredential(IdentityCredentialsTest.generatePassword("scram-sha-1", "password", "salt", 1));
        credentials = credentials.withCredential((Credential)credential1);
        this.assertCredentials(credentials, credential1, "scram-sha-1");
        PasswordCredential credential2 = new PasswordCredential(IdentityCredentialsTest.generatePassword("scram-sha-256", "password", "salt", 2));
        credentials = credentials.withCredential((Credential)credential2);
        this.assertCredentials(credentials, credential1, "scram-sha-1");
        this.assertCredentials(credentials, credential2, "scram-sha-256");
        PasswordCredential credential3 = new PasswordCredential(IdentityCredentialsTest.generatePassword("scram-sha-512", "password", "salt", 3));
        credentials = credentials.withCredential((Credential)credential3);
        this.assertCredentials(credentials, credential1, "scram-sha-1");
        this.assertCredentials(credentials, credential2, "scram-sha-256");
        this.assertCredentials(credentials, credential3, "scram-sha-512");
    }

    private void assertCredentials(IdentityCredentials credentials, PasswordCredential credential, String algorithm) {
        Assert.assertNotNull((Object)credentials.getCredential(PasswordCredential.class));
        Assert.assertNotNull((Object)credentials.getCredential(PasswordCredential.class, algorithm));
        Assert.assertNotNull((Object)credentials.getCredential(PasswordCredential.class, algorithm, (AlgorithmParameterSpec)((ScramDigestPassword)credential.getPassword().castAs(ScramDigestPassword.class)).getParameterSpec()));
    }

    private static Password generatePassword(String algorithm, String password, String salt, int iterationCount) throws GeneralSecurityException {
        IteratedSaltedPasswordAlgorithmSpec algoSpec = new IteratedSaltedPasswordAlgorithmSpec(iterationCount, salt.getBytes(StandardCharsets.UTF_8));
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)algoSpec);
        return PasswordFactory.getInstance((String)algorithm, ServerUtils.ELYTRON_PASSWORD_PROVIDERS).generatePassword((KeySpec)encSpec);
    }
}

