/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.credential.store.CredentialStoreBuilder;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.sasl.plain.PlainSaslServerFactory;
import org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;

public class CredentialStoreSaslAuthenticationTest {
    private static final String PLAIN = "PLAIN";
    private static final String USERNAME = "Guest";
    private static final String PASSWORD = "gpwd";
    private static final String CREDENTIAL_CONFIG_FILE = "wildfly-credential-sasl-config.xml";
    private static String BASE_STORE_DIRECTORY = "target/ks-cred-stores";
    private static final Provider[] providers = new Provider[]{WildFlyElytronSaslPlainProvider.getInstance(), WildFlyElytronPasswordProvider.getInstance()};

    @BeforeClass
    public static void setUp() throws Exception {
        System.setProperty("wildfly.config.url", CredentialStoreSaslAuthenticationTest.class.getResource(CREDENTIAL_CONFIG_FILE).toExternalForm());
        Security.insertProviderAt(providers[1], 1);
        CredentialStoreBuilder.get().setKeyStoreFile(BASE_STORE_DIRECTORY + "/mycredstore.cs").setKeyStoreType("JCEKS").setKeyStorePassword("StorePassword").addPassword(USERNAME, PASSWORD).build();
        Security.removeProvider(providers[1].getName());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CredentialStoreSaslAuthenticationTest.cleanCredentialStore();
    }

    private static void cleanCredentialStore() {
        File file = new File(BASE_STORE_DIRECTORY + "/mycredstore.cs");
        file.delete();
    }

    @Test
    public void testSuccessfulSaslAuthenticationWithCredentialStore() throws Exception {
        SaslServer server = new SaslServerBuilder(PlainSaslServerFactory.class, PLAIN).setProviderSupplier(() -> providers).setUserName(USERNAME).setPassword(PASSWORD.toCharArray()).build();
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SaslClient client = contextConfigurationClient.createSaslClient(new URI(CREDENTIAL_CONFIG_FILE), (AuthenticationConfiguration)context.authRules.getConfiguration(), Arrays.asList(PLAIN));
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"\u0000Guest\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)USERNAME, (Object)server.getAuthorizationID());
    }

    @Test
    public void testUnsuccessfulSaslAuthenticationWithCredentialStore() throws Exception {
        SaslServer server = new SaslServerBuilder(PlainSaslServerFactory.class, PLAIN).setProviderSupplier(() -> providers).setUserName(USERNAME).setPassword("Guestgpwd".toCharArray()).build();
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SaslClient client = contextConfigurationClient.createSaslClient(new URI(CREDENTIAL_CONFIG_FILE), (AuthenticationConfiguration)context.authRules.getConfiguration(), Arrays.asList(PLAIN));
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"\u0000Guest\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expected exception but no exception thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }
}

