/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.impl.ElytronMessages;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.OneTimePasswordAlgorithmSpec;
import org.wildfly.security.password.spec.OneTimePasswordSpec;

class OneTimePasswordImpl
extends AbstractPasswordImpl
implements OneTimePassword {
    private static final long serialVersionUID = 5524179164918986449L;
    private final String algorithm;
    private final byte[] hash;
    private final String seed;
    private final int sequenceNumber;

    OneTimePasswordImpl(String algorithm, byte[] hash, String seed, int sequenceNumber) {
        this.algorithm = algorithm;
        this.hash = hash;
        this.seed = seed;
        this.sequenceNumber = sequenceNumber;
    }

    OneTimePasswordImpl(OneTimePassword password) {
        this(password.getAlgorithm(), (byte[])password.getHash().clone(), password.getSeed(), password.getSequenceNumber());
    }

    OneTimePasswordImpl(String algorithm, OneTimePasswordSpec spec) {
        this(algorithm, (byte[])spec.getHash().clone(), spec.getSeed(), spec.getSequenceNumber());
    }

    OneTimePasswordImpl(String algorithm, char[] password, OneTimePasswordAlgorithmSpec spec) throws SaslException {
        this(algorithm, OneTimePasswordImpl.generateOTP(algorithm, OneTimePasswordImpl.getNormalizedPasswordBytes(password), spec.getSeed().toLowerCase(Locale.ENGLISH), spec.getSequenceNumber()), spec.getSeed(), spec.getSequenceNumber());
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    public String getSeed() {
        return this.seed;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(OneTimePasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new OneTimePasswordSpec((byte[])this.hash.clone(), this.seed, this.sequenceNumber)));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        throw new InvalidKeyException();
    }

    private static byte[] generateOTP(String algorithm, byte[] passPhrase, String seed, int sequenceNumber) throws SaslException {
        MessageDigest messageDigest;
        try {
            messageDigest = OneTimePasswordImpl.getMessageDigest(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.mechInvalidOTPAlgorithm(algorithm);
        }
        ByteStringBuilder seedAndPassPhrase = new ByteStringBuilder();
        seedAndPassPhrase.append(seed);
        seedAndPassPhrase.append(passPhrase);
        byte[] hash = OneTimePasswordImpl.hashAndFold(algorithm, messageDigest, seedAndPassPhrase.toArray());
        for (int i = 0; i < sequenceNumber; ++i) {
            messageDigest.reset();
            hash = OneTimePasswordImpl.hashAndFold(algorithm, messageDigest, hash);
        }
        return hash;
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case "otp-md5": {
                return MessageDigest.getInstance("MD5");
            }
            case "otp-sha1": {
                return MessageDigest.getInstance("SHA-1");
            }
            case "otp-sha256": {
                return MessageDigest.getInstance("SHA-256");
            }
            case "otp-sha384": {
                return MessageDigest.getInstance("SHA-384");
            }
            case "otp-sha512": {
                return MessageDigest.getInstance("SHA-512");
            }
        }
        throw new NoSuchAlgorithmException();
    }

    private static byte[] hashAndFold(String algorithm, MessageDigest messageDigest, byte[] input) {
        messageDigest.update(input);
        byte[] result = messageDigest.digest();
        byte[] hash = new byte[8];
        for (int i = 8; i < result.length; ++i) {
            int n = i % 8;
            result[n] = (byte)(result[n] ^ result[i]);
        }
        System.arraycopy(result, 0, hash, 0, 8);
        if (algorithm.equals("otp-sha1")) {
            OneTimePasswordImpl.reverse(hash, 0, 4);
            OneTimePasswordImpl.reverse(hash, 4, 4);
        }
        return hash;
    }

    private static void reverse(byte[] bytes, int offset, int length) {
        int mid = length / 2 + offset;
        int i = offset;
        int j = offset + length - 1;
        while (i < mid) {
            byte tmp = bytes[i];
            bytes[i] = bytes[j];
            bytes[j] = tmp;
            ++i;
            --j;
        }
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(OneTimePasswordSpec.class);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)Arrays.hashCode(this.hash), (int)this.seed.hashCode()), (int)this.sequenceNumber), (int)this.algorithm.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OneTimePasswordImpl)) {
            return false;
        }
        OneTimePasswordImpl other = (OneTimePasswordImpl)obj;
        return this.sequenceNumber == other.sequenceNumber && this.algorithm.equals(other.algorithm) && Arrays.equals(this.hash, other.hash) && this.seed.equals(other.seed);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return OneTimePassword.createRaw((String)this.algorithm, (byte[])this.hash, (String)this.seed, (int)this.sequenceNumber);
    }

    @Override
    public OneTimePasswordImpl clone() {
        return this;
    }
}

