/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;

final class PrivilegedServerMechanism
implements HttpServerAuthenticationMechanism {
    private final HttpServerAuthenticationMechanism mechanism;
    private final AccessControlContext accessControlContext;

    PrivilegedServerMechanism(HttpServerAuthenticationMechanism mechanism, AccessControlContext accessControlContext) {
        this.mechanism = (HttpServerAuthenticationMechanism)Assert.checkNotNullParam((String)"mechanism", (Object)mechanism);
        this.accessControlContext = (AccessControlContext)Assert.checkNotNullParam((String)"accessControlContext", (Object)accessControlContext);
    }

    public String getMechanismName() {
        return this.mechanism.getMechanismName();
    }

    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            AccessController.doPrivileged(() -> {
                this.mechanism.evaluateRequest((HttpServerRequest)new HttpServerRequestWrapper(request));
                return null;
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | HttpAuthenticationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    public Object getNegotiatedProperty(String propertyName) {
        return this.mechanism.getNegotiatedProperty(propertyName);
    }

    public <T> T getNegotiationProperty(String propertyName, Class<T> type) {
        return (T)this.mechanism.getNegotiationProperty(propertyName, type);
    }

    private HttpServerMechanismsResponder wrap(HttpServerMechanismsResponder toWrap) {
        return toWrap != null ? r -> {
            try {
                AccessController.doPrivileged(() -> {
                    toWrap.sendResponse(r);
                    return null;
                }, this.accessControlContext);
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof HttpAuthenticationException) {
                    throw (HttpAuthenticationException)e.getCause();
                }
                throw new HttpAuthenticationException((Throwable)e);
            }
        } : null;
    }

    private class HttpServerRequestWrapper
    implements HttpServerRequest {
        private final HttpServerRequest wrapped;

        private HttpServerRequestWrapper(HttpServerRequest toWrap) {
            this.wrapped = toWrap;
        }

        public List<String> getRequestHeaderValues(String headerName) {
            return this.wrapped.getRequestHeaderValues(headerName);
        }

        public String getFirstRequestHeaderValue(String headerName) {
            return this.wrapped.getFirstRequestHeaderValue(headerName);
        }

        public SSLSession getSSLSession() {
            return this.wrapped.getSSLSession();
        }

        public Certificate[] getPeerCertificates() {
            return this.wrapped.getPeerCertificates();
        }

        public HttpScope getScope(Scope scope) {
            return this.wrapped.getScope(scope);
        }

        public Collection<String> getScopeIds(Scope scope) {
            return this.wrapped.getScopeIds(scope);
        }

        public HttpScope getScope(Scope scope, String id) {
            return this.wrapped.getScope(scope, id);
        }

        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            this.wrapped.noAuthenticationInProgress(PrivilegedServerMechanism.this.wrap(responder));
        }

        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            this.wrapped.authenticationInProgress(PrivilegedServerMechanism.this.wrap(responder));
        }

        public void authenticationComplete(HttpServerMechanismsResponder responder) {
            this.wrapped.authenticationComplete(PrivilegedServerMechanism.this.wrap(responder));
        }

        public void authenticationComplete(HttpServerMechanismsResponder responder, Runnable logoutHandler) {
            this.wrapped.authenticationComplete(responder, logoutHandler);
        }

        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            this.wrapped.authenticationFailed(message, PrivilegedServerMechanism.this.wrap(responder));
        }

        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            this.wrapped.badRequest(failure, PrivilegedServerMechanism.this.wrap(responder));
        }

        public String getRequestMethod() {
            return this.wrapped.getRequestMethod();
        }

        public URI getRequestURI() {
            return this.wrapped.getRequestURI();
        }

        public String getRequestPath() {
            return this.wrapped.getRequestPath();
        }

        public Map<String, List<String>> getParameters() {
            return this.wrapped.getParameters();
        }

        public Set<String> getParameterNames() {
            return this.wrapped.getParameterNames();
        }

        public List<String> getParameterValues(String name) {
            return this.wrapped.getParameterValues(name);
        }

        public String getFirstParameterValue(String name) {
            return this.wrapped.getFirstParameterValue(name);
        }

        public List<HttpServerCookie> getCookies() {
            return this.wrapped.getCookies();
        }

        public InputStream getInputStream() {
            return this.wrapped.getInputStream();
        }

        public InetSocketAddress getSourceAddress() {
            return this.wrapped.getSourceAddress();
        }

        public boolean suspendRequest() {
            return this.wrapped.suspendRequest();
        }

        public boolean resumeRequest() {
            return this.wrapped.resumeRequest();
        }
    }
}

