/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawUnixDESCryptPassword;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public interface UnixDESCryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_CRYPT_DES = "crypt-des";

    public short getSalt();

    public byte[] getHash();

    @Override
    default public SaltedPasswordAlgorithmSpec getParameterSpec() {
        short salt = this.getSalt();
        byte[] saltBytes = new byte[]{(byte)(salt >>> 8 & 0xFF), (byte)(salt & 0xFF)};
        return new SaltedPasswordAlgorithmSpec(saltBytes);
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"parameterSpec", (Object)parameterSpec);
        return parameterSpec.equals(this.getParameterSpec());
    }

    @Override
    public UnixDESCryptPassword clone();

    public static UnixDESCryptPassword createRaw(String algorithm, short salt, byte[] hash) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        return new RawUnixDESCryptPassword(algorithm, salt, hash);
    }
}

