/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.Inet;
import org.wildfly.security.auth.client.MatchAbstractTypeAuthorityRule;
import org.wildfly.security.auth.client.MatchAbstractTypeRule;
import org.wildfly.security.auth.client.MatchHostRule;
import org.wildfly.security.auth.client.MatchNetworkRule;
import org.wildfly.security.auth.client.MatchNoUserRule;
import org.wildfly.security.auth.client.MatchPathRule;
import org.wildfly.security.auth.client.MatchPortRule;
import org.wildfly.security.auth.client.MatchSchemeRule;
import org.wildfly.security.auth.client.MatchSchemeSpecificPartRule;
import org.wildfly.security.auth.client.MatchUserRule;
import org.wildfly.security.auth.client._private.ElytronMessages;

public abstract class MatchRule {
    private final MatchRule parent;
    public static final MatchRule ALL = new MatchRule(null){

        @Override
        MatchRule reparent(MatchRule newParent) {
            return this;
        }

        @Override
        public boolean isProtocolMatched() {
            return false;
        }

        @Override
        public boolean isTypeMatched() {
            return false;
        }

        @Override
        public boolean isTypeAuthorityMatched() {
            return false;
        }

        @Override
        public String getMatchProtocol() {
            return null;
        }

        @Override
        public String getMatchAbstractType() {
            return null;
        }

        @Override
        public String getMatchAbstractTypeAuthority() {
            return null;
        }

        @Override
        public boolean isHostMatched() {
            return false;
        }

        @Override
        public String getMatchHost() {
            return null;
        }

        @Override
        public boolean isPathMatched() {
            return false;
        }

        @Override
        public String getMatchPath() {
            return null;
        }

        @Override
        public boolean isPortMatched() {
            return false;
        }

        @Override
        public int getMatchPort() {
            return 0;
        }

        @Override
        public boolean isUserMatched() {
            return true;
        }

        @Override
        public String getMatchUser() {
            return null;
        }

        @Override
        public boolean isUrnNameMatched() {
            return false;
        }

        @Override
        public String getMatchUrnName() {
            return null;
        }

        @Override
        public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
            return true;
        }

        @Override
        MatchRule without(Class<? extends MatchRule> clazz) {
            return this;
        }

        @Override
        boolean halfEqual(MatchRule other) {
            return true;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        StringBuilder asString(StringBuilder b) {
            return b;
        }
    };

    MatchRule(MatchRule parent) {
        this.parent = parent;
    }

    abstract MatchRule reparent(MatchRule var1);

    public final boolean equals(Object other) {
        return other instanceof MatchRule && this.equals((MatchRule)other);
    }

    public final boolean equals(MatchRule other) {
        return this.hashCode() == other.hashCode() && this.halfEqual(other) && other.halfEqual(this);
    }

    abstract boolean halfEqual(MatchRule var1);

    final boolean parentHalfEqual(MatchRule other) {
        return this.parent.halfEqual(other);
    }

    public abstract int hashCode();

    final int parentHashCode() {
        return this.parent.hashCode();
    }

    MatchRule without(Class<? extends MatchRule> clazz) {
        if (clazz.isInstance(this)) {
            return this.parent;
        }
        MatchRule newParent = this.parent.without(clazz);
        if (this.parent == newParent) {
            return this;
        }
        return this.reparent(newParent);
    }

    public final boolean matches(URI uri) {
        return this.matches(uri, null, null);
    }

    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        return this.parent.matches(uri, abstractType, abstractTypeAuthority);
    }

    public boolean isProtocolMatched() {
        return this.parent.isProtocolMatched();
    }

    public String getMatchProtocol() {
        return this.parent.getMatchProtocol();
    }

    public boolean isTypeMatched() {
        return this.parent.isTypeMatched();
    }

    public boolean isTypeAuthorityMatched() {
        return this.parent.isTypeAuthorityMatched();
    }

    public String getMatchAbstractType() {
        return this.parent.getMatchAbstractType();
    }

    public String getMatchAbstractTypeAuthority() {
        return this.parent.getMatchAbstractTypeAuthority();
    }

    public final MatchRule matchProtocol(String protoName) {
        if (protoName == null || protoName.equals("*")) {
            return this.without(MatchSchemeRule.class);
        }
        return new MatchSchemeRule(this, protoName);
    }

    public final MatchRule matchAbstractType(String typeName, String authorityName) {
        MatchRule baseRule = typeName == null || typeName.equals("*") ? this.without(MatchAbstractTypeRule.class) : new MatchAbstractTypeRule(this, typeName);
        if (authorityName == null || authorityName.equals("*")) {
            return baseRule.without(MatchAbstractTypeAuthorityRule.class);
        }
        return new MatchAbstractTypeAuthorityRule(baseRule, authorityName);
    }

    public boolean isHostMatched() {
        return this.parent.isHostMatched();
    }

    public String getMatchHost() {
        return this.parent.getMatchHost();
    }

    public boolean isNetworkMatched() {
        return this.parent.isNetworkMatched();
    }

    public CidrAddress getMatchNetwork() {
        return this.parent.getMatchNetwork();
    }

    public final MatchRule matchHost(String hostSpec) {
        if (hostSpec == null || hostSpec.equals("*")) {
            return this.without(MatchHostRule.class).without(MatchNetworkRule.class);
        }
        CidrAddress cidrAddress = Inet.parseCidrAddress((String)hostSpec);
        if (cidrAddress != null) {
            return new MatchNetworkRule(this, cidrAddress);
        }
        InetAddress inetAddress = Inet.parseInetAddress((String)hostSpec);
        if (inetAddress != null) {
            return new MatchNetworkRule(this, CidrAddress.create((InetAddress)inetAddress, (int)(inetAddress instanceof Inet6Address ? 128 : 32)));
        }
        return new MatchHostRule(this, hostSpec);
    }

    public final MatchRule matchAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return this.without(MatchHostRule.class).without(MatchNetworkRule.class);
        }
        return new MatchNetworkRule(this, CidrAddress.create((InetAddress)inetAddress, (int)(inetAddress instanceof Inet6Address ? 128 : 32)));
    }

    public final MatchRule matchNetwork(CidrAddress cidrAddress) {
        if (cidrAddress == null) {
            return this.without(MatchHostRule.class).without(MatchNetworkRule.class);
        }
        return new MatchNetworkRule(this, cidrAddress);
    }

    public boolean isPathMatched() {
        return this.parent.isPathMatched();
    }

    public String getMatchPath() {
        return this.parent.getMatchPath();
    }

    public final MatchRule matchPath(String pathSpec) {
        if (pathSpec == null || pathSpec.equals("**") || pathSpec.equals("/**")) {
            return this.without(MatchPathRule.class);
        }
        return new MatchPathRule(this, pathSpec);
    }

    public boolean isPortMatched() {
        return this.parent.isPortMatched();
    }

    public int getMatchPort() {
        return this.parent.getMatchPort();
    }

    public final MatchRule matchPort(int port) {
        if (port <= 0 || port > 65535) {
            throw ElytronMessages.log.invalidPortNumber(port);
        }
        return new MatchPortRule(this, port);
    }

    public boolean isUserMatched() {
        return this.parent.isUserMatched();
    }

    public String getMatchUser() {
        return this.parent.getMatchUser();
    }

    public final MatchRule matchUser(String userSpec) {
        return userSpec == null ? this.matchNoUser() : new MatchUserRule(this, userSpec);
    }

    public final MatchRule matchNoUser() {
        return new MatchNoUserRule(this);
    }

    public final MatchRule matchAnyUser() {
        return this.without(MatchUserRule.class).without(MatchNoUserRule.class);
    }

    public boolean isUrnNameMatched() {
        return this.parent.isUrnNameMatched();
    }

    public String getMatchUrnName() {
        return this.parent.getMatchUrnName();
    }

    public final MatchRule matchUrnName(String name) {
        return name == null ? this.without(MatchSchemeSpecificPartRule.class) : new MatchSchemeSpecificPartRule(this, name);
    }

    public final MatchRule matchLocalSecurityDomain(String name) {
        return name == null ? this.matchProtocol(null).matchUrnName(null) : this.matchProtocol("domain").matchUrnName(name);
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.asString(b);
        if (b.length() > 1) {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    final StringBuilder parentAsString(StringBuilder b) {
        return this.parent.asString(b);
    }

    abstract StringBuilder asString(StringBuilder var1);
}

