/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.SimpleAttributesEntry;

public interface Attributes {
    public static final Attributes EMPTY = new Attributes(){

        @Override
        public Collection<Entry> entries() {
            return Collections.emptySet();
        }

        @Override
        public int size(String key) {
            return 0;
        }

        @Override
        public boolean remove(String key) {
            return false;
        }

        @Override
        public String get(String key, int idx) {
            return null;
        }

        @Override
        public Entry get(String key) {
            return new SimpleAttributesEntry(this, key);
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public Collection<Entry> entries();

    public int size(String var1);

    public Entry get(String var1);

    public String get(String var1, int var2);

    public int size();

    default public boolean remove(String key) {
        throw Assert.unsupported();
    }

    default public void add(String key, int idx, String value) {
        throw Assert.unsupported();
    }

    default public String set(String key, int idx, String value) {
        throw Assert.unsupported();
    }

    default public String remove(String key, int idx) {
        throw Assert.unsupported();
    }

    default public void clear() {
        throw Assert.unsupported();
    }

    default public List<String> copyAndRemove(String key) {
        Entry values = this.get(key);
        ArrayList<String> copy = values.isEmpty() ? Collections.emptyList() : new ArrayList<String>(values);
        this.remove(key);
        return copy;
    }

    default public Collection<String> values() {
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator<Entry> entries = Attributes.this.entries().iterator();
                return new Iterator<String>(){
                    private Iterator<String> values;

                    @Override
                    public boolean hasNext() {
                        while (true) {
                            if (this.values == null) {
                                if (!entries.hasNext()) {
                                    return false;
                                }
                                this.values = ((Entry)entries.next()).iterator();
                                continue;
                            }
                            if (this.values.hasNext()) {
                                return true;
                            }
                            this.values = null;
                        }
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.values.next();
                    }

                    @Override
                    public void remove() {
                        Iterator<String> values = this.values;
                        if (values == null) {
                            throw new IllegalStateException();
                        }
                        values.remove();
                    }
                };
            }

            @Override
            public void clear() {
                Attributes.this.clear();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean changed = false;
                for (Entry entries : Attributes.this.entries()) {
                    changed = entries.removeAll(c) || changed;
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean changed = false;
                for (Entry entries : Attributes.this.entries()) {
                    changed = entries.retainAll(c) || changed;
                }
                return changed;
            }

            @Override
            public boolean isEmpty() {
                for (Entry entries : Attributes.this.entries()) {
                    if (entries.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int size() {
                int size = 0;
                for (Entry entries : Attributes.this.entries()) {
                    size += entries.size();
                }
                return size;
            }
        };
    }

    default public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator<Entry> entries = Attributes.this.entries().iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public String next() {
                        return ((Entry)entries.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        entries.remove();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof String && Attributes.this.containsKey((String)o);
            }

            @Override
            public boolean remove(Object o) {
                return o instanceof String && Attributes.this.remove((String)o);
            }

            @Override
            public void clear() {
                Attributes.this.clear();
            }

            @Override
            public int size() {
                return Attributes.this.size();
            }
        };
    }

    default public boolean set(String key, int idx, String expect, String update) {
        Assert.checkNotNullParam((String)"update", (Object)update);
        if (expect == null || idx < 0 || idx >= this.size(key) || !this.get(key, idx).equals(expect)) {
            return false;
        }
        this.set(key, idx, update);
        return true;
    }

    default public int indexOf(String key, String value) {
        int size = this.size(key);
        for (int i = 0; i < size; ++i) {
            if (!this.get(key, i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    default public int lastIndexOf(String key, String value) {
        int size = this.size(key);
        for (int i = size - 1; i >= 0; --i) {
            if (!this.get(key, i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    default public void removeRange(String key, int from, int to) {
        for (int i = to - 1; i >= from; --i) {
            this.remove(key, i);
        }
    }

    default public String getFirst(String key) {
        return this.get(key, 0);
    }

    default public String getLast(String key) {
        return this.get(key, this.size(key) - 1);
    }

    default public void addFirst(String key, String value) {
        this.add(key, 0, value);
    }

    default public void addLast(String key, String value) {
        this.add(key, this.size(key), value);
    }

    default public String removeFirst(String key) {
        return this.remove(key, 0);
    }

    default public String removeLast(String key) {
        return this.remove(key, this.size(key) - 1);
    }

    default public boolean remove(String key, int idx, String value) {
        if (this.get(key, idx).equals(value)) {
            this.remove(key, idx);
            return true;
        }
        return false;
    }

    default public boolean removeFirst(String key, String value) {
        int idx = this.indexOf(key, value);
        return idx >= 0 && this.remove(key, idx, value);
    }

    default public boolean removeLast(String key, String value) {
        int idx = this.lastIndexOf(key, value);
        return idx >= 0 && this.remove(key, idx, value);
    }

    default public boolean removeAll(String key, String value) {
        int idx = this.lastIndexOf(key, value);
        if (idx == -1) {
            return false;
        }
        while (idx >= 0) {
            this.remove(key, idx, value);
            idx = this.lastIndexOf(key, value);
        }
        return true;
    }

    default public boolean addAll(Map<String, ? extends Collection<String>> map) {
        Assert.checkNotNullParam((String)"map", map);
        boolean changed = false;
        for (Map.Entry<String, ? extends Collection<String>> entry : map.entrySet()) {
            Collection<String> value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            String key = entry.getKey();
            changed = this.addAll(key, value) || changed;
        }
        return changed;
    }

    default public boolean addAll(String key, Collection<String> values) {
        Assert.checkNotNullParam((String)"key", (Object)key);
        Assert.checkNotNullParam((String)"values", values);
        boolean changed = false;
        for (String s : values) {
            if (s == null) continue;
            this.addLast(key, s);
            changed = true;
        }
        return changed;
    }

    default public boolean containsKey(String key) {
        return key != null && this.size(key) > 0;
    }

    default public boolean containsValue(String key, String value) {
        return key != null && value != null && this.indexOf(key, value) >= 0;
    }

    default public List<String> copyAndReplace(String key, Collection<String> values) {
        List<String> old = this.copyAndRemove(key);
        this.addAll(key, values);
        return old;
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public Attributes asReadOnly() {
        return new Attributes(){
            private Map<String, Entry> entryCache = new HashMap<String, Entry>();
            private Collection<Entry> cachedEntries;

            @Override
            public Collection<Entry> entries() {
                if (this.cachedEntries != null) {
                    return this.cachedEntries;
                }
                this.cachedEntries = new AbstractCollection<Entry>(){

                    @Override
                    public Iterator<Entry> iterator() {
                        final Iterator<String> iterator = Attributes.this.keySet().iterator();
                        return new Iterator<Entry>(){

                            @Override
                            public boolean hasNext() {
                                return iterator.hasNext();
                            }

                            @Override
                            public Entry next() {
                                return this.get((String)iterator.next());
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return Attributes.this.keySet().size();
                    }
                };
                return this.cachedEntries;
            }

            @Override
            public int size(String key) {
                return Attributes.this.size(key);
            }

            @Override
            public String get(String key, int idx) {
                return Attributes.this.get(key, idx);
            }

            @Override
            public int size() {
                return Attributes.this.size();
            }

            @Override
            public synchronized Entry get(String key) {
                return this.entryCache.computeIfAbsent(key, s -> new SimpleAttributesEntry(this, (String)s));
            }
        };
    }

    public static interface Entry
    extends List<String> {
        public String getKey();

        public void removeRange(int var1, int var2);

        @Override
        default public Spliterator<String> spliterator() {
            return Spliterators.spliterator(this, 272);
        }
    }

    public static interface SetEntry
    extends Entry,
    Set<String> {
        @Override
        default public Spliterator<String> spliterator() {
            return Spliterators.spliterator(this, 273);
        }
    }
}

