/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.server.AddUser;
import org.wildfly.plugin.server.Archives;
import org.wildfly.plugin.server.ArtifactResolver;
import org.wildfly.plugin.server.ModulesPath;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends AbstractServerConnection {
    public static final String WILDFLY_DIR = "wildfly-run";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Inject
    private ArtifactResolver artifactResolver;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(property="wildfly.artifact")
    private String artifact;
    @Parameter(defaultValue="org.wildfly", property="wildfly.groupId")
    private String groupId;
    @Parameter(defaultValue="wildfly-dist", property="wildfly.artifactId")
    private String artifactId;
    @Parameter(property="wildfly.classifier")
    private String classifier;
    @Parameter(property="wildfly.packaging", defaultValue="zip")
    private String packaging;
    @Parameter(property="wildfly.version")
    private String version;
    @Parameter(alias="modules-path", property="wildfly.modulesPath")
    private ModulesPath modulesPath;
    @Deprecated
    @Parameter(alias="jvm-args", property="wildfly.jvmArgs")
    private String jvmArgs;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(alias="java-home", property="java.home")
    private String javaHome;
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    private String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    @Parameter(alias="server-args", property="wildfly.serverArgs")
    private String[] serverArgs;
    @Parameter(alias="add-user", property="wildfly.add-user")
    private AddUser addUser;
    @Parameter
    private Map<String, String> env;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Parameter(alias="runtime-name", property="wildfly.deployment.runtime.name")
    private String runtimeName;
    @Parameter(defaultValue="${project.build.directory}/", property="wildfly.deployment.targetDir")
    private File targetDir;
    @Parameter(property="wildfly.deployment.filename")
    private String filename;
    @Parameter(alias="check-packaging", property="wildfly.checkPackaging", defaultValue="true")
    private boolean checkPackaging;
    @Deprecated
    @Parameter(alias="before-deployment")
    private Commands beforeDeployment;
    @Deprecated
    @Parameter(alias="after-deployment")
    private Commands afterDeployment;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Inject
    private CommandExecutor commandExecutor;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        Log log = this.getLog();
        Path deploymentContent = this.getDeploymentContent();
        if (Files.notExists(deploymentContent, new LinkOption[0])) {
            throw new MojoExecutionException(String.format("The deployment '%s' could not be found.", deploymentContent.toAbsolutePath()));
        }
        Path wildflyPath = this.extractIfRequired(deploymentContent.getParent());
        if (!ServerHelper.isValidHomeDirectory((Path)wildflyPath)) {
            throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", wildflyPath));
        }
        StandaloneCommandBuilder commandBuilder = this.createCommandBuilder(wildflyPath);
        log.info((CharSequence)("JAVA_HOME : " + commandBuilder.getJavaHome()));
        log.info((CharSequence)("JBOSS_HOME: " + commandBuilder.getWildFlyHome()));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getJavaOptions(), " ")));
        try {
            if (this.addUser != null && this.addUser.hasUsers()) {
                log.info((CharSequence)("Adding users: " + this.addUser));
                this.addUser.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
            }
            log.info((CharSequence)"Server is starting up. Press CTRL + C to stop the server.");
            Process process = this.startContainer((CommandBuilder)commandBuilder);
            try (ModelControllerClient client = this.createClient();
                 MavenModelControllerClientConfiguration configuration = this.getClientConfiguration();){
                if (this.beforeDeployment != null) {
                    this.commandExecutor.execute(configuration, wildflyPath, this.beforeDeployment);
                }
                Deployment deployment = Deployment.of((Path)deploymentContent).setName(this.name).setRuntimeName(this.runtimeName);
                DeploymentManager deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client);
                deploymentManager.forceDeploy(deployment);
                if (this.afterDeployment != null) {
                    this.commandExecutor.execute(configuration, wildflyPath, this.afterDeployment);
                }
            }
            try {
                boolean keepRunning = true;
                while (keepRunning) {
                    int exitCode = process.waitFor();
                    if (exitCode == 10) {
                        process.destroy();
                        process = this.startContainer((CommandBuilder)commandBuilder);
                        continue;
                    }
                    keepRunning = false;
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("The server failed to start", e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    private StandaloneCommandBuilder createCommandBuilder(Path wildflyPath) {
        StandaloneCommandBuilder commandBuilder = (StandaloneCommandBuilder)StandaloneCommandBuilder.of((Path)wildflyPath).setJavaHome(this.javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setJavaOptions(this.javaOpts);
        } else if (Utils.isNotNullOrEmpty(this.jvmArgs)) {
            commandBuilder.setJavaOptions(this.jvmArgs.split("\\s+"));
        }
        if (this.serverConfig != null) {
            commandBuilder.setServerConfiguration(this.serverConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        return commandBuilder;
    }

    private Path extractIfRequired(Path buildDir) throws MojoFailureException, MojoExecutionException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        String artifact = ArtifactResolver.ArtifactNameSplitter.of(this.artifact).setArtifactId(this.artifactId).setClassifier(this.classifier).setGroupId(this.groupId).setPackaging(this.packaging).setVersion(this.version).asString();
        Path result = this.artifactResolver.resolve(this.project, artifact).toPath();
        Path target = buildDir.resolve(WILDFLY_DIR);
        if (Files.exists(target, new LinkOption[0])) {
            try {
                Archives.deleteDirectory(target);
            }
            catch (IOException e) {
                throw new MojoFailureException("Could not delete target directory: " + target, (Throwable)e);
            }
        }
        try {
            Archives.unzip(result, target);
            Iterator<Path> iterator = Files.newDirectoryStream(target).iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Artifact was not successfully extracted: " + result, (Throwable)e);
        }
        throw new MojoFailureException("Artifact was not successfully extracted: " + result);
    }

    @Override
    public String goal() {
        return "run";
    }

    private Process startContainer(CommandBuilder commandBuilder) throws IOException, InterruptedException, TimeoutException {
        Launcher launcher = Launcher.of((CommandBuilder)commandBuilder).inherit();
        if (this.env != null) {
            launcher.addEnvironmentVariables(this.env);
        }
        Process process = launcher.launch();
        try (ModelControllerClient client = this.createClient();){
            ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.startupTimeout);
        }
        return process;
    }

    private Path getDeploymentContent() {
        PackageType packageType = PackageType.resolve(this.project);
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        return this.targetDir.toPath().resolve(filename);
    }
}

