/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.StandardOutput;

@Named
@Singleton
public class OfflineCLIExecutor
extends AbstractLogEnabled {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(String wildflyHome, Commands commands, StandardOutput stdout, Map<String, String> systemProperties, String[] javaOpts) throws IOException {
        try {
            if (commands.hasScripts()) {
                for (File f : commands.getScripts()) {
                    Path script2 = f.toPath();
                    this.getLogger().info("Executing script: " + script2);
                    int exitCode = this.executeInNewProcess(wildflyHome, script2, systemProperties, stdout, javaOpts);
                    if (exitCode == 0) continue;
                    return exitCode;
                }
            }
            if (!commands.hasCommands()) return 0;
            Path script = Files.createTempFile("wildfly-maven-plugin-cli-script", ".cli", new FileAttribute[0]);
            try {
                try (BufferedWriter writer = Files.newBufferedWriter(script, StandardCharsets.UTF_8, new OpenOption[0]);){
                    if (commands.isBatch()) {
                        writer.write("batch");
                        writer.newLine();
                    }
                    for (String cmd : commands.getCommands()) {
                        writer.write(cmd);
                        writer.newLine();
                    }
                    if (commands.isBatch()) {
                        writer.write("run-batch");
                        writer.newLine();
                    }
                }
                int exitCode = this.executeInNewProcess(wildflyHome, script, systemProperties, stdout, javaOpts);
                if (exitCode == 0) return 0;
                int n = exitCode;
                return n;
            }
            finally {
                Files.deleteIfExists(script);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInNewProcess(String wildflyHome, Path scriptFile, Map<String, String> systemProperties, StandardOutput stdout, String[] javaOpts) throws InterruptedException, IOException {
        Logger log = this.getLogger();
        CliCommandBuilder builder = CliCommandBuilder.of((String)wildflyHome).setScriptFile(scriptFile);
        if (systemProperties != null) {
            systemProperties.forEach((key, value) -> builder.addJavaOption(String.format("-D%s=%s", key, value)));
            if (systemProperties.containsKey("module.path")) {
                builder.setModuleDirs(new String[]{systemProperties.get("module.path")});
            }
        }
        if (javaOpts != null) {
            log.debug("java opts: " + Arrays.toString(javaOpts));
            for (String opt : javaOpts) {
                opt = opt.replaceAll("\n", "").trim();
                log.debug(String.format("opt: '%s'", opt));
                if (opt.trim().isEmpty()) continue;
                builder.addJavaOption(opt);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("process parameters: " + builder.build());
        }
        Launcher launcher = Launcher.of((CommandBuilder)builder).addEnvironmentVariable("JBOSS_HOME", wildflyHome).setRedirectErrorStream(true);
        stdout.getRedirect().ifPresent(arg_0 -> ((Launcher)launcher).redirectOutput(arg_0));
        Process process = launcher.launch();
        Optional<Thread> consoleConsumer = stdout.startConsumer(process);
        try {
            int n = process.waitFor();
            return n;
        }
        finally {
            if (process.isAlive()) {
                process.destroyForcibly();
            }
            consoleConsumer.ifPresent(Thread::interrupt);
        }
    }
}

