/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.wildfly.openssl.ByteBufferUtils;
import org.wildfly.openssl.CipherSuiteConverter;
import org.wildfly.openssl.Messages;
import org.wildfly.openssl.OpenSSLContextSPI;
import org.wildfly.openssl.OpenSSLSessionContext;
import org.wildfly.openssl.OpenSSlSession;
import org.wildfly.openssl.SSL;
import org.wildfly.openssl.ServerALPNCallback;

public final class OpenSSLEngine
extends SSLEngine {
    private static final Logger LOG = Logger.getLogger(OpenSSLEngine.class.getName());
    private static final SSLException ENGINE_CLOSED = new SSLException("Engine is closed");
    private static final SSLException RENEGOTIATION_UNSUPPORTED = new SSLException("Renegotiation is not supported");
    private static final SSLException ENCRYPTED_PACKET_OVERSIZED = new SSLException("Oversized packet");
    static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    protected static final int VERIFY_DEPTH = 10;
    private static final String[] SUPPORTED_PROTOCOLS;
    private static final Set<String> SUPPORTED_PROTOCOLS_SET;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    public static final int DEFAULT_CERTIFICATE_VALIDATION_DEPTH = 100;
    private static final AtomicIntegerFieldUpdater<OpenSSLEngine> DESTROYED_UPDATER;
    static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final long EMPTY_ADDR;
    private final long sslCtx;
    private long ssl = 0L;
    private long networkBIO = 0L;
    private final OpenSSLContextSPI openSSLContextSPI;
    private int accepted;
    private boolean alpnRegistered = false;
    private boolean handshakeFinished;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private volatile ClientAuthMode clientAuth = ClientAuthMode.NONE;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private boolean clientMode;
    private String[] applicationProtocols;
    private String selectedApplicationProtocol;
    private SSLSession handshakeSession;
    private String host;
    private int port;

    public OpenSSLSessionContext getSessionContext() {
        if (this.clientMode) {
            return this.openSSLContextSPI.engineGetClientSessionContext();
        }
        return this.openSSLContextSPI.engineGetServerSessionContext();
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    OpenSSLEngine(long sslCtx, boolean clientMode, OpenSSLContextSPI openSSLContextSPI) {
        this(sslCtx, clientMode, openSSLContextSPI, null, -1);
    }

    OpenSSLEngine(long sslCtx, boolean clientMode, OpenSSLContextSPI openSSLContextSPI, String host, int port) {
        if (sslCtx == 0L) {
            throw new IllegalStateException(Messages.MESSAGES.noSslContext());
        }
        this.sslCtx = sslCtx;
        this.clientMode = clientMode;
        this.openSSLContextSPI = openSSLContextSPI;
        this.host = host;
        this.port = port;
    }

    private void initSsl() {
        if (this.ssl == 0L && DESTROYED_UPDATER.get(this) == 0) {
            this.ssl = SSL.getInstance().newSSL(this.sslCtx, !this.clientMode);
            this.networkBIO = SSL.getInstance().makeNetworkBIO(this.ssl);
            if (this.clientMode) {
                this.openSSLContextSPI.engineGetClientSessionContext().tryAttachClientSideSession(this.ssl, this.host, this.port);
            }
        }
    }

    public synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            if (this.ssl != 0L) {
                SSL.getInstance().freeSSL(this.ssl);
                SSL.getInstance().freeBIO(this.networkBIO);
            }
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer src) {
        int sslWrote;
        int pos = src.position();
        int limit = src.limit();
        int len = Math.min(limit - pos, 16384);
        this.initSsl();
        if (src.isDirect()) {
            long addr = SSL.getInstance().bufferAddress(src) + (long)pos;
            sslWrote = SSL.getInstance().writeToSSL(this.ssl, addr, len);
            if (sslWrote > 0) {
                src.position(pos + sslWrote);
                return sslWrote;
            }
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(len);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                src.limit(pos + len);
                buf.put(src);
                src.limit(limit);
                sslWrote = SSL.getInstance().writeToSSL(this.ssl, addr, len);
                if (sslWrote > 0) {
                    src.position(pos + sslWrote);
                    int n = sslWrote;
                    return n;
                }
                src.position(pos);
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer(buf);
            }
        }
        throw new IllegalStateException(Messages.MESSAGES.sslWriteFailed(sslWrote));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeEncryptedData(ByteBuffer src) {
        int pos = src.position();
        int len = src.remaining();
        if (src.isDirect()) {
            long addr = SSL.getInstance().bufferAddress(src) + (long)pos;
            int netWrote = SSL.getInstance().writeToBIO(this.networkBIO, addr, len);
            if (netWrote >= 0) {
                src.position(pos + netWrote);
                return netWrote;
            }
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(len);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                buf.put(src);
                int netWrote = SSL.getInstance().writeToBIO(this.networkBIO, addr, len);
                if (netWrote >= 0) {
                    src.position(pos + netWrote);
                    int n = netWrote;
                    return n;
                }
                src.position(pos);
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer(buf);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer dst) {
        this.initSsl();
        if (dst.isDirect()) {
            int pos = dst.position();
            long addr = SSL.getInstance().bufferAddress(dst) + (long)pos;
            int len = dst.limit() - pos;
            int sslRead = SSL.getInstance().readFromSSL(this.ssl, addr, len);
            if (sslRead > 0) {
                dst.position(pos + sslRead);
                return sslRead;
            }
        } else {
            int pos = dst.position();
            int limit = dst.limit();
            int len = Math.min(18713, limit - pos);
            ByteBuffer buf = ByteBuffer.allocateDirect(len);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                int sslRead = SSL.getInstance().readFromSSL(this.ssl, addr, len);
                if (sslRead > 0) {
                    buf.limit(sslRead);
                    dst.limit(pos + sslRead);
                    dst.put(buf);
                    dst.limit(limit);
                    int n = sslRead;
                    return n;
                }
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer(buf);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readEncryptedData(ByteBuffer dst, int pending) {
        if (dst.isDirect() && dst.remaining() >= pending) {
            int pos = dst.position();
            long addr = SSL.getInstance().bufferAddress(dst) + (long)pos;
            int bioRead = SSL.getInstance().readFromBIO(this.networkBIO, addr, pending);
            if (bioRead > 0) {
                dst.position(pos + bioRead);
                return bioRead;
            }
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(pending);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                int bioRead = SSL.getInstance().readFromBIO(this.networkBIO, addr, pending);
                if (bioRead > 0) {
                    buf.limit(bioRead);
                    int oldLimit = dst.limit();
                    dst.limit(dst.position() + bioRead);
                    dst.put(buf);
                    dst.limit(oldLimit);
                    int n = bioRead;
                    return n;
                }
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer(buf);
            }
        }
        return 0;
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (this.destroyed != 0) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (srcs == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.bufferIsNull());
        }
        if (dst == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.bufferIsNull());
        }
        if (offset + length > srcs.length) {
            throw new IndexOutOfBoundsException(Messages.MESSAGES.invalidOffset(offset, length, srcs.length));
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        }
        int bytesProduced = 0;
        int pendingNet = SSL.getInstance().pendingWrittenBytesInBIO(this.networkBIO);
        if (pendingNet > 0) {
            int capacity = dst.remaining();
            if (capacity < pendingNet) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, bytesProduced);
            }
            try {
                bytesProduced += this.readEncryptedData(dst, pendingNet);
            }
            catch (Exception e) {
                throw new SSLException(e);
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), 0, bytesProduced);
        }
        int bytesConsumed = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.bufferIsNull());
            }
            while (src.hasRemaining()) {
                try {
                    bytesConsumed += this.writePlaintextData(src);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                pendingNet = SSL.getInstance().pendingWrittenBytesInBIO(this.networkBIO);
                if (pendingNet <= 0) continue;
                int capacity = dst.remaining();
                if (capacity < pendingNet) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), bytesConsumed, bytesProduced);
                }
                try {
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced += this.readEncryptedData(dst, pendingNet));
            }
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        long error;
        if (this.destroyed != 0) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        this.initSsl();
        if (src == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.bufferIsNull());
        }
        if (dsts == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.bufferIsNull());
        }
        if (offset >= dsts.length || offset + length > dsts.length) {
            throw new IndexOutOfBoundsException(Messages.MESSAGES.invalidOffset(offset, length, dsts.length));
        }
        int capacity = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer dst = dsts[i];
            if (dst == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.bufferIsNull());
            }
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            capacity += dst.remaining();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        }
        int len = src.remaining();
        if (len > 18713) {
            this.isInboundDone = true;
            this.isOutboundDone = true;
            this.engineClosed = true;
            this.shutdown();
            throw ENCRYPTED_PACKET_OVERSIZED;
        }
        int bytesConsumed = -1;
        try {
            int written = this.writeEncryptedData(src);
            if (written >= 0) {
                bytesConsumed = bytesConsumed == -1 ? written : (bytesConsumed += written);
            }
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
        int lastPrimingReadResult = SSL.getInstance().readFromSSL(this.ssl, EMPTY_ADDR, 0);
        if (lastPrimingReadResult <= 0 && (error = (long)SSL.getInstance().getLastErrorNumber()) != 0L) {
            String err = SSL.getInstance().getErrorString(error);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(Messages.MESSAGES.readFromSSLFailed(error, lastPrimingReadResult, err));
            }
            this.shutdown();
            throw new SSLException(err);
        }
        if (bytesConsumed < 0) {
            bytesConsumed = 0;
        }
        int pendingApp = this.handshakeFinished || SSL.getInstance().isInInit(this.ssl) == 0 ? SSL.getInstance().pendingReadableBytesInSSL(this.ssl) : 0;
        int bytesProduced = 0;
        while (pendingApp > 0) {
            if (capacity < pendingApp) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), bytesConsumed, 0);
            }
            int idx = offset;
            while (idx < endOffset) {
                int bytesRead;
                ByteBuffer dst = dsts[idx];
                if (!dst.hasRemaining()) {
                    ++idx;
                    continue;
                }
                if (pendingApp <= 0) break;
                try {
                    bytesRead = this.readPlaintextData(dst);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                if (bytesRead == 0) break;
                bytesProduced += bytesRead;
                pendingApp -= bytesRead;
                if (dst.hasRemaining()) continue;
                ++idx;
            }
            pendingApp = SSL.getInstance().pendingReadableBytesInSSL(this.ssl);
        }
        if (!this.receivedShutdown && (SSL.getInstance().getShutdown(this.ssl) & 2) == 2) {
            this.receivedShutdown = true;
            this.closeOutbound();
            this.closeInbound();
        }
        if (bytesProduced == 0 && bytesConsumed == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), bytesConsumed, bytesProduced);
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced);
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        this.shutdown();
        if (this.accepted != 0 && !this.receivedShutdown) {
            throw new SSLException(Messages.MESSAGES.inboundIsClosed());
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.accepted != 0 && this.destroyed == 0) {
            int mode = SSL.getInstance().getShutdown(this.ssl);
            if ((mode & 1) != 1) {
                SSL.getInstance().shutdownSSL(this.ssl);
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return OpenSSLContextSPI.getAvailableCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        this.initSsl();
        String[] enabled = SSL.getInstance().getCiphers(this.ssl);
        if (enabled == null) {
            return new String[0];
        }
        for (int i = 0; i < enabled.length; ++i) {
            String mapped = OpenSSLEngine.toJavaCipherSuite(enabled[i], this.ssl);
            if (mapped == null) continue;
            enabled[i] = mapped;
        }
        return enabled;
    }

    @Override
    public void setEnabledCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nullCipherSuites());
        }
        this.initSsl();
        StringBuilder buf = new StringBuilder();
        for (String cipherSuite : cipherSuites) {
            HashSet<String> availbile;
            if (cipherSuite == null) break;
            String converted = CipherSuiteConverter.toOpenSsl(cipherSuite);
            if (converted != null) {
                cipherSuite = converted;
            }
            if (!(availbile = new HashSet<String>(Arrays.asList(OpenSSLContextSPI.getAvailableCipherSuites()))).contains(cipherSuite) && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unsupported cypher suite " + cipherSuite + "(" + converted + "), available " + availbile);
            }
            buf.append(cipherSuite);
            buf.append(':');
        }
        if (buf.length() == 0) {
            throw new IllegalArgumentException(Messages.MESSAGES.emptyCipherSuiteList());
        }
        buf.setLength(buf.length() - 1);
        String cipherSuiteSpec = buf.toString();
        try {
            SSL.getInstance().setCipherSuites(this.ssl, cipherSuiteSpec);
        }
        catch (Exception e) {
            throw new IllegalStateException(Messages.MESSAGES.failedCipherSuite(cipherSuiteSpec), e);
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return (String[])SUPPORTED_PROTOCOLS.clone();
    }

    @Override
    public String[] getEnabledProtocols() {
        int size;
        this.initSsl();
        ArrayList<String> enabled = new ArrayList<String>();
        enabled.add("SSLv2Hello");
        int opts = SSL.getInstance().getOptions(this.ssl);
        if ((opts & 0x4000000) == 0) {
            enabled.add("TLSv1");
        }
        if ((opts & 0x10000000) == 0) {
            enabled.add("TLSv1.1");
        }
        if ((opts & 0x8000000) == 0) {
            enabled.add("TLSv1.2");
        }
        if ((opts & 0x1000000) == 0) {
            enabled.add("SSLv2");
        }
        if ((opts & 0x2000000) == 0) {
            enabled.add("SSLv3");
        }
        if ((size = enabled.size()) == 0) {
            return new String[0];
        }
        return enabled.toArray(new String[size]);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException();
        }
        this.initSsl();
        boolean sslv2 = false;
        boolean sslv3 = false;
        boolean tlsv1 = false;
        boolean tlsv1_1 = false;
        boolean tlsv1_2 = false;
        for (String p : protocols) {
            if (!SUPPORTED_PROTOCOLS_SET.contains(p)) {
                throw new IllegalArgumentException(Messages.MESSAGES.unsupportedProtocol(p));
            }
            if (p.equals("SSLv2")) {
                sslv2 = true;
                continue;
            }
            if (p.equals("SSLv3")) {
                sslv3 = true;
                continue;
            }
            if (p.equals("TLSv1")) {
                tlsv1 = true;
                continue;
            }
            if (p.equals("TLSv1.1")) {
                tlsv1_1 = true;
                continue;
            }
            if (!p.equals("TLSv1.2")) continue;
            tlsv1_2 = true;
        }
        SSL.getInstance().setOptions(this.ssl, 4095);
        if (!sslv2) {
            SSL.getInstance().setOptions(this.ssl, 0x1000000);
        }
        if (!sslv3) {
            SSL.getInstance().setOptions(this.ssl, 0x2000000);
        }
        if (!tlsv1) {
            SSL.getInstance().setOptions(this.ssl, 0x4000000);
        }
        if (!tlsv1_1) {
            SSL.getInstance().setOptions(this.ssl, 0x10000000);
        }
        if (!tlsv1_2) {
            SSL.getInstance().setOptions(this.ssl, 0x8000000);
        }
    }

    @Override
    public SSLSession getSession() {
        this.initSsl();
        if (!this.handshakeFinished) {
            return this.getHandshakeSession();
        }
        return this.getSessionContext().getSession(SSL.getInstance().getSessionId(this.getSsl()));
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        block8: {
            block7: {
                if (this.engineClosed || this.destroyed != 0) {
                    throw ENGINE_CLOSED;
                }
                if (!this.clientMode) break block7;
                switch (this.accepted) {
                    case 0: {
                        this.handshake();
                        this.accepted = 2;
                        break block8;
                    }
                    case 1: {
                        this.accepted = 2;
                        break block8;
                    }
                    case 2: {
                        throw RENEGOTIATION_UNSUPPORTED;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (this.accepted > 0) {
                this.renegotiate();
            }
            this.accepted = 2;
        }
    }

    private void beginHandshakeImplicitly() throws SSLException {
        if (this.engineClosed || this.destroyed != 0) {
            throw ENGINE_CLOSED;
        }
        if (this.accepted == 0) {
            this.handshake();
            this.accepted = 1;
        }
    }

    private void handshake() throws SSLException {
        int code;
        this.initSsl();
        if (!this.alpnRegistered) {
            this.alpnRegistered = true;
            if (this.applicationProtocols != null) {
                if (!this.isClientMode()) {
                    SSL.getInstance().setServerALPNCallback(this.ssl, new ServerALPNCallback(){

                        @Override
                        public String select(String[] data) {
                            for (String proto : OpenSSLEngine.this.applicationProtocols) {
                                for (String clientProto : data) {
                                    if (!clientProto.equals(proto)) continue;
                                    OpenSSLEngine.this.selectedApplicationProtocol = proto;
                                    return proto;
                                }
                            }
                            return null;
                        }
                    });
                } else {
                    SSL.getInstance().setAlpnProtos(this.ssl, this.applicationProtocols);
                }
            }
        }
        if ((code = SSL.getInstance().doHandshake(this.ssl)) <= 0) {
            long error = SSL.getInstance().getLastErrorNumber();
            if (error != 0L) {
                String err = SSL.getInstance().getErrorString(error);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Engine handshake failure " + err);
                }
                this.shutdown();
                throw new SSLException(err);
            }
        } else {
            this.handshakeFinished();
        }
    }

    private void handshakeFinished() {
        this.handshakeFinished = true;
        if (this.isClientMode() && this.applicationProtocols != null) {
            this.selectedApplicationProtocol = SSL.getInstance().getAlpnSelected(this.ssl);
        }
        if (this.handshakeSession != null || this.clientMode) {
            byte[] sessionId = SSL.getInstance().getSessionId(this.ssl);
            if (this.handshakeSession != null) {
                this.getSessionContext().mergeHandshakeSession(this.handshakeSession, sessionId);
            }
            if (this.clientMode) {
                this.openSSLContextSPI.engineGetClientSessionContext().storeClientSideSession(this.ssl, this.host, this.port, sessionId);
            }
        }
    }

    private void renegotiate() throws SSLException {
        long error;
        this.initSsl();
        this.handshakeFinished = false;
        int code = SSL.getInstance().renegotiate(this.ssl);
        if (code <= 0 && (error = (long)SSL.getInstance().getLastErrorNumber()) != 0L) {
            String err = SSL.getInstance().getErrorString(error);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Renegotiation failure " + err);
            }
            this.shutdown();
            throw new SSLException(err);
        }
    }

    private static long memoryAddress(ByteBuffer buf) {
        return SSL.getInstance().bufferAddress(buf);
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.accepted == 0 || this.destroyed != 0) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        this.initSsl();
        if (!this.handshakeFinished) {
            if (SSL.getInstance().pendingWrittenBytesInBIO(this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (SSL.getInstance().isInInit(this.ssl) == 0) {
                this.handshakeFinished();
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.engineClosed) {
            if (SSL.getInstance().pendingWrittenBytesInBIO(this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    static String toJavaCipherSuite(String openSslCipherSuite, long ssl) {
        if (openSslCipherSuite == null) {
            return null;
        }
        String prefix = OpenSSLEngine.toJavaCipherSuitePrefix(SSL.getInstance().getVersion(ssl));
        return CipherSuiteConverter.toJava(openSslCipherSuite, prefix);
    }

    private static String toJavaCipherSuitePrefix(String protocolVersion) {
        int c = protocolVersion == null || protocolVersion.length() == 0 ? 0 : (int)protocolVersion.charAt(0);
        switch (c) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        if (this.ssl == 0L) {
            this.clientMode = clientMode;
        } else if (clientMode != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.REQUIRE : ClientAuthMode.NONE);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuthMode.REQUIRE;
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.OPTIONAL : ClientAuthMode.NONE);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.clientAuth == ClientAuthMode.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuthMode mode) {
        if (this.clientMode) {
            return;
        }
        this.initSsl();
        OpenSSLEngine openSSLEngine = this;
        synchronized (openSSLEngine) {
            if (this.clientAuth == mode) {
                return;
            }
            switch (mode) {
                case NONE: {
                    SSL.getInstance().setSSLVerify(this.ssl, 0, 10);
                    break;
                }
                case REQUIRE: {
                    SSL.getInstance().setSSLVerify(this.ssl, 2, 10);
                    break;
                }
                case OPTIONAL: {
                    SSL.getInstance().setSSLVerify(this.ssl, 1, 10);
                }
            }
            this.clientAuth = mode;
        }
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        if (b) {
            // empty if block
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    @Override
    public SSLSession getHandshakeSession() {
        this.initSsl();
        if (this.handshakeFinished) {
            return null;
        }
        if (this.handshakeSession == null) {
            this.handshakeSession = new OpenSSlSession(!this.clientMode, this.getSessionContext());
        }
        return this.handshakeSession;
    }

    public String getSelectedApplicationProtocol() {
        return this.selectedApplicationProtocol;
    }

    public String[] getApplicationProtocols() {
        return this.applicationProtocols;
    }

    public void setApplicationProtocols(String ... applicationProtocols) {
        this.applicationProtocols = applicationProtocols;
    }

    public static boolean isAlpnSupported() {
        return SSL.getInstance().isAlpnSupported();
    }

    long getSsl() {
        this.initSsl();
        return this.ssl;
    }

    boolean isHandshakeFinished() {
        return this.handshakeFinished;
    }

    @Override
    public SSLParameters getSSLParameters() {
        return super.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters sslParameters) {
        super.setSSLParameters(sslParameters);
        this.initSsl();
        boolean orderCiphersSupported = false;
        try {
            orderCiphersSupported = SSL.getInstance().hasOp(0x400000);
            if (orderCiphersSupported && sslParameters.getUseCipherSuitesOrder()) {
                SSL.getInstance().setSSLOptions(this.ssl, 0x400000);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (!orderCiphersSupported) {
            LOG.fine("The version of SSL in use does not support cipher ordering");
        }
        int value = 0;
        value = sslParameters.getNeedClientAuth() ? 2 : (sslParameters.getWantClientAuth() ? 1 : 0);
        SSL.getInstance().setSSLVerify(this.ssl, value, 100);
    }

    void setHost(String host) {
        this.host = host;
    }

    void setPort(int port) {
        this.port = port;
    }

    static {
        ENGINE_CLOSED.setStackTrace(new StackTraceElement[0]);
        RENEGOTIATION_UNSUPPORTED.setStackTrace(new StackTraceElement[0]);
        ENCRYPTED_PACKET_OVERSIZED.setStackTrace(new StackTraceElement[0]);
        DESTROYED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OpenSSLEngine.class, "destroyed");
        SUPPORTED_PROTOCOLS = new String[]{"SSLv2Hello", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
        SUPPORTED_PROTOCOLS_SET = new HashSet<String>(Arrays.asList(SUPPORTED_PROTOCOLS));
        EMPTY_ADDR = SSL.getInstance().bufferAddress(ByteBuffer.allocate(0));
    }

    static enum ClientAuthMode {
        NONE,
        OPTIONAL,
        REQUIRE;

    }
}

