/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import org.wildfly.openssl.OpenSSLSessionContext;
import org.wildfly.openssl.SSL;

public final class OpenSSLServerSessionContext
extends OpenSSLSessionContext {
    OpenSSLServerSessionContext(long context) {
        super(context);
        SSL.getInstance().registerSessionContext(context, this);
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        SSL.getInstance().setSessionCacheTimeout(this.context, seconds);
    }

    @Override
    public int getSessionTimeout() {
        return (int)SSL.getInstance().getSessionCacheTimeout(this.context);
    }

    @Override
    public void setSessionCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        SSL.getInstance().setSessionCacheSize(this.context, size);
    }

    @Override
    public int getSessionCacheSize() {
        return (int)SSL.getInstance().getSessionCacheSize(this.context);
    }

    @Override
    public void setSessionCacheEnabled(boolean enabled) {
        long l;
        if (enabled) {
            SSL.getInstance();
            l = 2L;
        } else {
            SSL.getInstance();
            l = 0L;
        }
        long mode = l;
        SSL.getInstance().setSessionCacheMode(this.context, mode);
    }

    @Override
    public boolean isSessionCacheEnabled() {
        long l = SSL.getInstance().getSessionCacheMode(this.context);
        SSL.getInstance();
        return l == 2L;
    }

    public boolean setSessionIdContext(byte[] sidCtx) {
        return SSL.getInstance().setSessionIdContext(this.context, sidCtx);
    }
}

