/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatables;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class DemoDatatable
extends WebMarkupContainer {
    private static final long serialVersionUID = -4387194295178034384L;

    public DemoDatatable(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"display")))});
    }

    public void renderHead(IHeaderResponse response) {
        this.renderDemoCSS(response);
        this.renderBasicJS(response);
        StringBuilder js = new StringBuilder();
        js.append("$(document).ready( function() {\n");
        js.append("\t$('#" + this.getMarkupId() + "').dataTable( {\n");
        js.append("\t\t\"bJQueryUI\": true,\n");
        js.append("\t\t\"sPaginationType\": \"full_numbers\"\n");
        js.append("\t} );\n");
        js.append("} );");
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)js, (String)(this.getId() + "_datatables")));
    }

    private void renderDemoCSS(IHeaderResponse response) {
        Class<DemoDatatable> _ = DemoDatatable.class;
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(_, "media/css/demo_table_jui.css"), (String)"screen"));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(_, "media/css/" + this.getJUITheme() + "/jquery-ui-1.8.10.custom.css"), (String)"screen"));
    }

    private String getJUITheme() {
        return "smoothness";
    }

    private void renderBasicJS(IHeaderResponse response) {
        Class<DemoDatatable> _ = DemoDatatable.class;
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(_, "media/js/jquery.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(_, "media/js/jquery.dataTables.min.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(_, "media/js/jquery-ui-1.8.10.custom.min.js")));
    }
}

