/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.StorageProtos;

public class PreKeyRecord {
    private StorageProtos.PreKeyRecordStructure structure;

    public PreKeyRecord(int id, ECKeyPair keyPair) {
        this.structure = StorageProtos.PreKeyRecordStructure.newBuilder().setId(id).setPublicKey(ByteString.copyFrom((byte[])keyPair.getPublicKey().serialize())).setPrivateKey(ByteString.copyFrom((byte[])keyPair.getPrivateKey().serialize())).build();
    }

    public PreKeyRecord(byte[] serialized) throws IOException {
        this.structure = StorageProtos.PreKeyRecordStructure.parseFrom(serialized);
    }

    public int getId() {
        return this.structure.getId();
    }

    public ECKeyPair getKeyPair() {
        try {
            ECPublicKey publicKey = Curve.decodePoint(this.structure.getPublicKey().toByteArray(), 0);
            ECPrivateKey privateKey = Curve.decodePrivatePoint(this.structure.getPrivateKey().toByteArray());
            return new ECKeyPair(publicKey, privateKey);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] serialize() {
        return this.structure.toByteArray();
    }
}

