/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.ratchet;

import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.kdf.DerivedRootSecrets;
import org.whispersystems.libsignal.kdf.HKDF;
import org.whispersystems.libsignal.ratchet.ChainKey;
import org.whispersystems.libsignal.util.Pair;

public class RootKey {
    private final HKDF kdf;
    private final byte[] key;

    public RootKey(HKDF kdf, byte[] key) {
        this.kdf = kdf;
        this.key = key;
    }

    public byte[] getKeyBytes() {
        return this.key;
    }

    public Pair<RootKey, ChainKey> createChain(ECPublicKey theirRatchetKey, ECKeyPair ourRatchetKey) throws InvalidKeyException {
        byte[] sharedSecret = Curve.calculateAgreement(theirRatchetKey, ourRatchetKey.getPrivateKey());
        byte[] derivedSecretBytes = this.kdf.deriveSecrets(sharedSecret, this.key, "WhisperRatchet".getBytes(), 64);
        DerivedRootSecrets derivedSecrets = new DerivedRootSecrets(derivedSecretBytes);
        RootKey newRootKey = new RootKey(this.kdf, derivedSecrets.getRootKey());
        ChainKey newChainKey = new ChainKey(this.kdf, derivedSecrets.getChainKey(), 0);
        return new Pair<RootKey, ChainKey>(newRootKey, newChainKey);
    }
}

