/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.ratchet;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.kdf.DerivedMessageSecrets;
import org.whispersystems.libsignal.kdf.HKDF;
import org.whispersystems.libsignal.ratchet.MessageKeys;

public class ChainKey {
    private static final byte[] MESSAGE_KEY_SEED = new byte[]{1};
    private static final byte[] CHAIN_KEY_SEED = new byte[]{2};
    private final HKDF kdf;
    private final byte[] key;
    private final int index;

    public ChainKey(HKDF kdf, byte[] key, int index) {
        this.kdf = kdf;
        this.key = key;
        this.index = index;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getIndex() {
        return this.index;
    }

    public ChainKey getNextChainKey() {
        byte[] nextKey = this.getBaseMaterial(CHAIN_KEY_SEED);
        return new ChainKey(this.kdf, nextKey, this.index + 1);
    }

    public MessageKeys getMessageKeys() {
        byte[] inputKeyMaterial = this.getBaseMaterial(MESSAGE_KEY_SEED);
        byte[] keyMaterialBytes = this.kdf.deriveSecrets(inputKeyMaterial, "WhisperMessageKeys".getBytes(), 80);
        DerivedMessageSecrets keyMaterial = new DerivedMessageSecrets(keyMaterialBytes);
        return new MessageKeys(keyMaterial.getCipherKey(), keyMaterial.getMacKey(), keyMaterial.getIv(), this.index);
    }

    private byte[] getBaseMaterial(byte[] seed) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.key, "HmacSHA256"));
            return mac.doFinal(seed);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

