/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.protocol;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.whispersystems.curve25519.VrfSignatureVerificationFailedException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.devices.DeviceConsistencyCommitment;
import org.whispersystems.libsignal.devices.DeviceConsistencySignature;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.protocol.SignalProtos;

public class DeviceConsistencyMessage {
    private final DeviceConsistencySignature signature;
    private final int generation;
    private final byte[] serialized;

    public DeviceConsistencyMessage(DeviceConsistencyCommitment commitment, IdentityKeyPair identityKeyPair) {
        try {
            byte[] signatureBytes = Curve.calculateVrfSignature(identityKeyPair.getPrivateKey(), commitment.toByteArray());
            byte[] vrfOutputBytes = Curve.verifyVrfSignature(identityKeyPair.getPublicKey().getPublicKey(), commitment.toByteArray(), signatureBytes);
            this.generation = commitment.getGeneration();
            this.signature = new DeviceConsistencySignature(signatureBytes, vrfOutputBytes);
            this.serialized = SignalProtos.DeviceConsistencyCodeMessage.newBuilder().setGeneration(commitment.getGeneration()).setSignature(ByteString.copyFrom((byte[])this.signature.getSignature())).build().toByteArray();
        }
        catch (VrfSignatureVerificationFailedException | InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public DeviceConsistencyMessage(DeviceConsistencyCommitment commitment, byte[] serialized, IdentityKey identityKey) throws InvalidMessageException {
        try {
            SignalProtos.DeviceConsistencyCodeMessage message = SignalProtos.DeviceConsistencyCodeMessage.parseFrom(serialized);
            byte[] vrfOutputBytes = Curve.verifyVrfSignature(identityKey.getPublicKey(), commitment.toByteArray(), message.getSignature().toByteArray());
            this.generation = message.getGeneration();
            this.signature = new DeviceConsistencySignature(message.getSignature().toByteArray(), vrfOutputBytes);
            this.serialized = serialized;
        }
        catch (InvalidProtocolBufferException | VrfSignatureVerificationFailedException | InvalidKeyException e) {
            throw new InvalidMessageException(e);
        }
    }

    public byte[] getSerialized() {
        return this.serialized;
    }

    public DeviceConsistencySignature getSignature() {
        return this.signature;
    }

    public int getGeneration() {
        return this.generation;
    }
}

