/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.kdf;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.kdf.HKDFv2;
import org.whispersystems.libsignal.kdf.HKDFv3;

public abstract class HKDF {
    private static final int HASH_OUTPUT_SIZE = 32;

    public static HKDF createFor(int messageVersion) {
        switch (messageVersion) {
            case 2: {
                return new HKDFv2();
            }
            case 3: {
                return new HKDFv3();
            }
        }
        throw new AssertionError((Object)("Unknown version: " + messageVersion));
    }

    public byte[] deriveSecrets(byte[] inputKeyMaterial, byte[] info, int outputLength) {
        byte[] salt = new byte[32];
        return this.deriveSecrets(inputKeyMaterial, salt, info, outputLength);
    }

    public byte[] deriveSecrets(byte[] inputKeyMaterial, byte[] salt, byte[] info, int outputLength) {
        byte[] prk = this.extract(salt, inputKeyMaterial);
        return this.expand(prk, info, outputLength);
    }

    private byte[] extract(byte[] salt, byte[] inputKeyMaterial) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(salt, "HmacSHA256"));
            return mac.doFinal(inputKeyMaterial);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] expand(byte[] prk, byte[] info, int outputSize) {
        try {
            int iterations = (int)Math.ceil((double)outputSize / 32.0);
            byte[] mixin = new byte[]{};
            ByteArrayOutputStream results = new ByteArrayOutputStream();
            int remainingBytes = outputSize;
            for (int i = this.getIterationStartOffset(); i < iterations + this.getIterationStartOffset(); ++i) {
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(prk, "HmacSHA256"));
                mac.update(mixin);
                if (info != null) {
                    mac.update(info);
                }
                mac.update((byte)i);
                byte[] stepResult = mac.doFinal();
                int stepSize = Math.min(remainingBytes, stepResult.length);
                results.write(stepResult, 0, stepSize);
                mixin = stepResult;
                remainingBytes -= stepSize;
            }
            return results.toByteArray();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract int getIterationStartOffset();
}

