/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.weex.plugin.loader.compat;

import android.content.Context;
import com.alibaba.weex.plugin.loader.compat.ConfigXmlParser;
import com.alibaba.weex.plugin.loader.compat.PluginEntry;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.common.WXException;
import java.util.HashMap;
import java.util.Map;

class PluginManager {
    private static HashMap<String, PluginEntry> sComponents = new HashMap();
    private static HashMap<String, PluginEntry> sModules = new HashMap();

    PluginManager() {
    }

    public static void init(Context context) {
        PluginManager.loadConfig(context);
        PluginManager.registerComponents(sComponents);
        PluginManager.registerModules(sModules);
    }

    public static void registerComponent(String name, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            WXSDKEngine.registerComponent((String)name, clazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (WXException e) {
            e.printStackTrace();
        }
    }

    public static void registerModule(String name, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            WXSDKEngine.registerModule((String)name, clazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (WXException e) {
            e.printStackTrace();
        }
    }

    private static void registerComponents(HashMap<String, PluginEntry> components) {
        for (Map.Entry<String, PluginEntry> component : components.entrySet()) {
            PluginManager.registerComponent(component.getKey(), component.getValue().mPluginClass);
        }
    }

    private static void registerModules(HashMap<String, PluginEntry> modules) {
        for (Map.Entry<String, PluginEntry> module : modules.entrySet()) {
            PluginManager.registerModule(module.getKey(), module.getValue().mPluginClass);
        }
    }

    private static void loadConfig(Context context) {
        ConfigXmlParser parser = new ConfigXmlParser();
        parser.parse(context);
        sComponents = parser.getPluginComponents();
        sModules = parser.getPluginModules();
    }
}

