/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.weex.plugin.loader.compat;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.weex.plugin.loader.compat.PluginEntry;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class ConfigXmlParser {
    private static String TAG = "ConfigXmlParser";
    private String mService = "";
    private boolean mInsideFeature = false;
    private boolean mOnLoad = false;
    private String mApi = "";
    private String mPluginClass = "";
    private String mParamType = "";
    private String mCategory = "module";
    private HashMap<String, PluginEntry> mComponents = new HashMap(20);
    private HashMap<String, PluginEntry> mModules = new HashMap(20);

    ConfigXmlParser() {
    }

    public HashMap<String, PluginEntry> getPluginModules() {
        return this.mModules;
    }

    public HashMap<String, PluginEntry> getPluginComponents() {
        return this.mComponents;
    }

    public synchronized void parse(Context context) {
        int id = context.getResources().getIdentifier("config", "xml", context.getClass().getPackage().getName());
        if (id == 0 && (id = context.getResources().getIdentifier("config", "xml", context.getPackageName())) == 0) {
            Log.e((String)TAG, (String)"res/xml/config.xml is missing!");
            return;
        }
        this.parse((XmlPullParser)context.getResources().getXml(id));
    }

    private void parse(XmlPullParser xml) {
        int eventType = -1;
        while (eventType != 1) {
            if (eventType == 2) {
                this.handleStartTag(xml);
            } else if (eventType == 3) {
                this.handleEndTag(xml);
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleStartTag(XmlPullParser xml) {
        String strNode = xml.getName();
        if (strNode.equals("feature")) {
            this.mInsideFeature = true;
            this.mService = xml.getAttributeValue(null, "name");
        } else if (this.mInsideFeature && strNode.equals("param")) {
            this.mParamType = xml.getAttributeValue(null, "name");
            if (this.mParamType.equals("service")) {
                this.mService = xml.getAttributeValue(null, "value");
            } else if (this.mParamType.equals("package") || this.mParamType.equals("android-package")) {
                this.mPluginClass = xml.getAttributeValue(null, "value");
            } else if (this.mParamType.equals("onload")) {
                this.mOnLoad = "true".equals(xml.getAttributeValue(null, "value"));
            } else if (this.mParamType.equals("category")) {
                this.mCategory = xml.getAttributeValue(null, "value");
            } else if (this.mParamType.equals("api")) {
                this.mApi = xml.getAttributeValue(null, "value");
            }
        }
    }

    private void handleEndTag(XmlPullParser xml) {
        String strNode = xml.getName();
        if (strNode.equals("feature")) {
            if (TextUtils.equals((CharSequence)"module", (CharSequence)this.mCategory)) {
                this.mModules.put(this.mApi, new PluginEntry(this.mApi, this.mPluginClass, this.mOnLoad, "module"));
            } else if (TextUtils.equals((CharSequence)"component", (CharSequence)this.mCategory)) {
                this.mComponents.put(this.mApi, new PluginEntry(this.mApi, this.mPluginClass, this.mOnLoad, "component"));
            }
            this.mService = "";
            this.mPluginClass = "";
            this.mInsideFeature = false;
            this.mOnLoad = false;
            this.mCategory = "module";
            this.mApi = "";
            this.mParamType = "";
        }
    }
}

