"use strict";
/**
 * this module handles the difference between window (browser) and node js for specific functions and libraries.
 * env.js
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnvBtoa = function () {
    if (typeof window !== 'undefined')
        return window.btoa; // browser
    else
        return nodeBtoa; // node
};
exports.getEnvAtob = function () {
    if (typeof window !== 'undefined')
        return window.atob; // browser
    else
        return nodeAtob; // node
};
var nodeBtoa = function (str) {
    if (typeof Buffer === 'undefined')
        throw new Error('UnsupportedEnvironment');
    var buffer = Buffer.from(str.toString(), 'binary');
    return buffer.toString('base64');
};
var nodeAtob = function (str) {
    if (typeof Buffer === 'undefined')
        throw new Error('UnsupportedEnvironment');
    return Buffer.from(str, 'base64').toString('binary');
};
//# sourceMappingURL=env.js.map