/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.web3j.codegen.unit.gen.CompilerClassLoader;

public class ClassProvider {
    private final File pathToJavaFiles;

    public ClassProvider(File pathToJavaFiles) {
        this.pathToJavaFiles = pathToJavaFiles;
    }

    public final List<Class> getClasses() throws IOException {
        return this.loadClassesToList(this.compileClasses());
    }

    private CompilerClassLoader compileClasses() throws IOException {
        URL[] classPathURL = new URL[]{this.pathToJavaFiles.toURI().toURL()};
        Path outputDirectory = Files.createTempDirectory("tmp", new FileAttribute[0]);
        return new CompilerClassLoader(Objects.requireNonNull(outputDirectory).toFile(), classPathURL);
    }

    private List<Class> loadClassesToList(CompilerClassLoader compilerClassLoader) throws IOException {
        return this.getFormattedClassPath().stream().map(cp -> {
            try {
                return compilerClassLoader.loadClass(cp.replace(File.separator, "."));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private List<String> getFormattedClassPath() throws IOException {
        Stream<Path> walk = Files.walk(Paths.get(this.pathToJavaFiles.toURI()), new FileVisitOption[0]);
        return this.getClassPathFromURL(walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).collect(Collectors.toList()));
    }

    private List<String> getClassPathFromURL(List<String> listOfUrl) throws IOException {
        int length = this.pathToJavaFiles.getCanonicalPath().length();
        ArrayList<String> formattedClassPath = new ArrayList<String>();
        for (String s : listOfUrl) {
            formattedClassPath.add(s.substring(length + 1, s.lastIndexOf(".java")));
        }
        return formattedClassPath;
    }
}

