/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2.user;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css2.user.Css2Style;
import org.w3c.css.properties.css2.user.OutlineATSC;
import org.w3c.css.properties.css2.user.UserProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class OutlineWidthATSC
extends UserProperty {
    CssValue value;
    private static CssIdent thin = new CssIdent("thin");
    private static CssIdent medium = new CssIdent("medium");
    private static CssIdent thick = new CssIdent("thick");

    public OutlineWidthATSC() {
        this.value = medium;
    }

    public OutlineWidthATSC(OutlineWidthATSC another) {
        this.value = another.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutlineWidthATSC(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        ac.getFrame().addWarning("atsc", val.toString());
        if (val instanceof CssLength) {
            float f = ((Float)val.get()).floatValue();
            if (!(f >= 0.0f)) throw new InvalidParamException("negative-value", val.toString(), ac);
            this.value = val;
        } else if (val instanceof CssNumber) {
            this.value = ((CssNumber)val).getLength();
        } else if (val.equals(thin)) {
            this.value = thin;
        } else if (val.equals(medium)) {
            this.value = medium;
        } else if (val.equals(thick)) {
            this.value = thick;
        } else {
            if (!val.equals(inherit)) throw new InvalidParamException("value", val.toString(), "width", ac);
            this.value = CssProperty.inherit;
        }
        expression.next();
    }

    public OutlineWidthATSC(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public boolean isSoftlyInherited() {
        return this.value.equals(inherit);
    }

    public String toString() {
        return this.value.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        OutlineATSC outline = ((Css2Style)style).outlineATSC;
        if (outline.width != null) {
            style.addRedefinitionWarning(ac, this);
        }
        outline.width = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css2Style)style).getOutlineWidthATSC();
        }
        return ((Css2Style)style).outlineATSC.width;
    }

    public boolean equals(CssProperty property) {
        return property instanceof OutlineWidthATSC && this.value.equals(((OutlineWidthATSC)property).value);
    }

    public String getPropertyName() {
        return "outline-width";
    }
}

