/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2;

import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssBackgroundConstants;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css2.CssBackgroundAttachmentCSS2;
import org.w3c.css.properties.css2.CssBackgroundColorCSS2;
import org.w3c.css.properties.css2.CssBackgroundImageCSS2;
import org.w3c.css.properties.css2.CssBackgroundPositionCSS2;
import org.w3c.css.properties.css2.CssBackgroundRepeatCSS2;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;

public class CssBackgroundCSS2
extends CssProperty
implements CssOperator,
CssBackgroundConstants {
    public CssBackgroundColorCSS2 color;
    public CssBackgroundImageCSS2 image;
    public CssBackgroundRepeatCSS2 repeat;
    public CssBackgroundAttachmentCSS2 attachment;
    public CssBackgroundPositionCSS2 position;
    public boolean same;

    public CssProperty duplicate() {
        CssBackgroundCSS2 cloned = (CssBackgroundCSS2)super.duplicate();
        if (cloned != null) {
            if (this.color != null) {
                cloned.color = (CssBackgroundColorCSS2)this.color.duplicate();
            }
            if (this.image != null) {
                cloned.image = (CssBackgroundImageCSS2)this.image.duplicate();
            }
            if (this.repeat != null) {
                cloned.repeat = (CssBackgroundRepeatCSS2)this.repeat.duplicate();
            }
            if (this.attachment != null) {
                cloned.attachment = (CssBackgroundAttachmentCSS2)this.attachment.duplicate();
            }
            if (this.position != null) {
                cloned.position = (CssBackgroundPositionCSS2)this.position.duplicate();
            }
        }
        return cloned;
    }

    public CssBackgroundCSS2() {
    }

    public CssBackgroundCSS2(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        boolean manyValues;
        boolean find = true;
        if (check2 && expression.getCount() > 6) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        boolean bl = manyValues = expression.getCount() > 1;
        while (find) {
            find = false;
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val == null) break;
            if (manyValues && val != null && val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", null, null, ac);
            }
            if (check2 && val instanceof CssString) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (this.color == null) {
                try {
                    this.color = new CssBackgroundColorCSS2(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.image == null) {
                try {
                    this.image = new CssBackgroundImageCSS2(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.repeat == null) {
                try {
                    this.repeat = new CssBackgroundRepeatCSS2(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.attachment == null) {
                try {
                    this.attachment = new CssBackgroundAttachmentCSS2(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.position == null) {
                try {
                    this.position = new CssBackgroundPositionCSS2(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (check2 && val != null && !find) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            if (!check2 || find || val == null) continue;
            throw new InvalidParamException("unrecognize", ac);
        }
    }

    public CssBackgroundCSS2(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBackgroundAttachmentCSS2 getAttachment() {
        return this.attachment;
    }

    public void setAttachment(CssBackgroundAttachmentCSS2 attachment) {
        this.attachment = attachment;
    }

    public CssBackgroundImageCSS2 getImage() {
        return this.image;
    }

    public void setImage(CssBackgroundImageCSS2 image) {
        this.image = image;
    }

    public CssBackgroundRepeatCSS2 getRepeat() {
        return this.repeat;
    }

    public void setRepeat(CssBackgroundRepeatCSS2 repeat) {
        this.repeat = repeat;
    }

    public boolean isSame() {
        return this.same;
    }

    public void setSame(boolean same) {
        this.same = same;
    }

    public final CssBackgroundColorCSS2 getColor2() {
        return this.color;
    }

    public void setColor(CssBackgroundColorCSS2 color) {
        this.color = color;
    }

    public CssBackgroundPositionCSS2 getPosition() {
        return this.position;
    }

    public void setPosition(CssBackgroundPositionCSS2 position) {
        this.position = position;
    }

    public Object get() {
        return this.color;
    }

    public final CssValue getColor() {
        if (this.color == null) {
            return null;
        }
        return this.color.getColor();
    }

    public String getPropertyName() {
        return "background";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean addspace = false;
        if (this.color != null) {
            sb.append(this.color);
            addspace = true;
        }
        if (this.image != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.image);
            addspace = true;
        }
        if (this.repeat != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.repeat);
            addspace = true;
        }
        if (this.attachment != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.attachment);
            addspace = true;
        }
        if (this.position != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.position);
        }
        return sb.toString();
    }

    public void setImportant() {
        if (this.color != null) {
            this.color.important = true;
        }
        if (this.image != null) {
            this.image.important = true;
        }
        if (this.repeat != null) {
            this.repeat.important = true;
        }
        if (this.attachment != null) {
            this.attachment.important = true;
        }
        if (this.position != null) {
            this.position.important = true;
        }
    }

    public boolean getImportant() {
        return !(this.color != null && !this.color.important || this.image != null && !this.image.important || this.repeat != null && !this.repeat.important || this.attachment != null && !this.attachment.important || this.position != null && !this.position.important);
    }

    public void print(CssPrinterStyle printer) {
        if (!(this.color == null || this.image == null || this.repeat == null || this.attachment == null || this.position == null || !this.getImportant() && (this.image.important || this.color.important || this.repeat.important || this.attachment.important || this.position.important))) {
            if (this.color.byUser || this.image.byUser || this.repeat.byUser || this.attachment.byUser || this.position.byUser) {
                printer.print(this);
            }
        } else {
            if (this.color != null) {
                this.color.print(printer);
            }
            if (this.image != null) {
                this.image.print(printer);
            }
            if (this.repeat != null) {
                this.repeat.print(printer);
            }
            if (this.attachment != null) {
                this.attachment.print(printer);
            }
            if (this.position != null) {
                this.position.print(printer);
            }
        }
    }

    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.color != null) {
            this.color.setSelectors(selector);
        }
        if (this.image != null) {
            this.image.setSelectors(selector);
        }
        if (this.repeat != null) {
            this.repeat.setSelectors(selector);
        }
        if (this.attachment != null) {
            this.attachment.setSelectors(selector);
        }
        if (this.position != null) {
            this.position.setSelectors(selector);
        }
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        ((Css1Style)style).cssBackgroundCSS2.same = this.same;
        ((Css1Style)style).cssBackgroundCSS2.byUser = this.byUser;
        if (this.color != null) {
            this.color.addToStyle(ac, style);
        }
        if (this.image != null) {
            this.image.addToStyle(ac, style);
        }
        if (this.repeat != null) {
            this.repeat.addToStyle(ac, style);
        }
        if (this.attachment != null) {
            this.attachment.addToStyle(ac, style);
        }
        if (this.position != null) {
            this.position.addToStyle(ac, style);
        }
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackgroundCSS2();
        }
        return ((Css1Style)style).cssBackgroundCSS2;
    }

    public boolean equals(CssProperty property) {
        return false;
    }

    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.color != null) {
            this.color.setInfo(line, source);
        }
        if (this.image != null) {
            this.image.setInfo(line, source);
        }
        if (this.repeat != null) {
            this.repeat.setInfo(line, source);
        }
        if (this.attachment != null) {
            this.attachment.setInfo(line, source);
        }
        if (this.position != null) {
            this.position.setInfo(line, source);
        }
    }
}

