/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssBackground;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackgroundRepeat
extends CssProperty {
    private static final String propertyName = "background-repeat";
    public static final CssIdent repeat;
    private static HashMap<String, CssIdent> allowed_simple_values;
    private static HashMap<String, CssIdent> allowed_double_values;
    public Object value;

    public static boolean isMatchingIdent(CssIdent ident) {
        String id = ident.toString();
        return allowed_simple_values.containsKey(id) || allowed_double_values.containsKey(id);
    }

    public CssBackgroundRepeat() {
        this.value = repeat;
    }

    public CssBackgroundRepeat(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean is_complete = true;
        CssValueList vl = null;
        this.setByUser();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            CssIdent id_val = (CssIdent)val;
            if (inherit.equals(id_val)) {
                if (values.size() > 0 || expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                values.add(inherit);
            } else {
                String id_value = id_val.toString();
                CssIdent new_val = allowed_simple_values.get(id_value);
                if (new_val != null) {
                    if (!is_complete) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    values.add(new_val);
                    is_complete = true;
                } else {
                    new_val = allowed_double_values.get(id_value);
                    if (new_val == null) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (is_complete) {
                        vl = new CssValueList();
                        vl.add(new_val);
                    } else {
                        vl.add(new_val);
                        values.add(vl);
                    }
                    is_complete = !is_complete;
                }
            }
            expression.next();
            if (expression.end()) continue;
            if (!is_complete && op == ',') {
                values.add(vl);
                is_complete = true;
            }
            if ((!is_complete || op == ',') && (is_complete || op == ' ')) continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (!is_complete) {
            values.add(vl);
        }
        this.value = values.size() == 1 ? values.get(0) : values;
    }

    public CssBackgroundRepeat(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public void set(Object val) {
        this.value = val;
    }

    public boolean isSoftlyInherited() {
        return inherit == this.value;
    }

    public String toString() {
        if (this.value instanceof ArrayList) {
            ArrayList values = (ArrayList)this.value;
            StringBuilder sb = new StringBuilder();
            for (Object aValue : values) {
                sb.append(aValue.toString()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            return sb.toString();
        }
        return this.value.toString();
    }

    public final String getPropertyName() {
        return propertyName;
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackground cssBackground = ((Css1Style)style).cssBackground;
        if (cssBackground.repeat != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.repeat = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackgroundRepeat();
        }
        return ((Css1Style)style).cssBackground.repeat;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundRepeat && this.value == ((CssBackgroundRepeat)property).value;
    }

    public boolean isDefault() {
        return repeat == this.value;
    }

    static {
        allowed_simple_values = new HashMap();
        allowed_double_values = new HashMap();
        String[] REPEAT = new String[]{"repeat", "space", "round", "no-repeat"};
        allowed_simple_values.put("repeat-x", CssIdent.getIdent("repeat-x"));
        allowed_simple_values.put("repeat-y", CssIdent.getIdent("repeat-y"));
        for (String aREPEAT : REPEAT) {
            allowed_double_values.put(aREPEAT, CssIdent.getIdent(aREPEAT));
        }
        repeat = CssIdent.getIdent("repeat");
    }
}

