/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import java.util.ArrayList;
import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssBackgroundAttachment;
import org.w3c.css.properties.css.CssBackgroundClip;
import org.w3c.css.properties.css.CssBackgroundColor;
import org.w3c.css.properties.css.CssBackgroundImage;
import org.w3c.css.properties.css.CssBackgroundOrigin;
import org.w3c.css.properties.css.CssBackgroundPosition;
import org.w3c.css.properties.css.CssBackgroundRepeat;
import org.w3c.css.properties.css.CssBackgroundSize;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackground
extends CssProperty {
    private static final String propertyName = "background";
    Object value;
    public CssColor _color;
    public CssBackgroundColor color;
    public CssBackgroundImage image;
    public CssBackgroundRepeat repeat;
    public CssBackgroundAttachment attachment;
    public CssBackgroundPosition position;
    public CssBackgroundSize size;
    boolean same;

    public CssBackground() {
    }

    public CssBackground(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBackground(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssExpression single_layer = null;
        CssBackgroundValue b_val = null;
        ArrayList<CssBackgroundValue> values = new ArrayList<CssBackgroundValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = inherit;
                expression.next();
                return;
            }
            if (single_layer == null) {
                single_layer = new CssExpression();
            }
            single_layer.addValue(val);
            single_layer.setOperator(op);
            expression.next();
            if (expression.end()) continue;
            if (op == ',') {
                single_layer.setOperator(' ');
                b_val = this.check(ac, single_layer, check2, false);
                values.add(b_val);
                single_layer = null;
                continue;
            }
            if (op == ' ' || op == '/') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (single_layer != null) {
            b_val = this.check(ac, single_layer, check2, true);
            values.add(b_val);
        }
        this.value = values.size() == 1 ? values.get(0) : values;
        this.transform_into_individual_values();
    }

    private Object getCssBackgroundRepeatValue(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        char op = expression.getOperator();
        CssExpression exp = new CssExpression();
        exp.addValue(expression.getValue());
        this.repeat = new CssBackgroundRepeat(ac, exp, check2);
        if (op == ' ' && !expression.end()) {
            expression.next();
            if (!expression.end()) {
                CssValue val = expression.getValue();
                if (val.getType() == 0 && CssBackgroundRepeat.isMatchingIdent((CssIdent)val)) {
                    exp.addValue(expression.getValue());
                    exp.starts();
                    try {
                        this.repeat = new CssBackgroundRepeat(ac, exp, check2);
                    }
                    catch (InvalidParamException ipe) {
                        expression.precedent();
                    }
                } else {
                    expression.precedent();
                }
            }
        }
        return this.repeat.get();
    }

    private Object getCssBackgroundSizeValue(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        char op = expression.getOperator();
        CssExpression exp = new CssExpression();
        exp.addValue(expression.getValue());
        CssBackgroundSize bg_size = new CssBackgroundSize(ac, exp, check2);
        if (op == ' ' && !expression.end()) {
            expression.next();
            if (!expression.end()) {
                exp.addValue(expression.getValue());
                exp.starts();
                try {
                    bg_size = new CssBackgroundSize(ac, exp, check2);
                }
                catch (InvalidParamException ipe) {
                    expression.precedent();
                }
            }
        }
        return bg_size.get();
    }

    private Object getCssBackgroundPositionValue(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssExpression exp = new CssExpression();
        char op = expression.getOperator();
        exp.addValue(expression.getValue());
        int last_val = -1;
        CssBackgroundPosition bg_pos = new CssBackgroundPosition(ac, exp, check2);
        expression.mark();
        for (int i = 0; i < 3; ++i) {
            if (op != ' ' || expression.end()) continue;
            expression.next();
            if (expression.end()) break;
            exp.addValue(expression.getValue());
            exp.starts();
            try {
                bg_pos = new CssBackgroundPosition(ac, exp, check2);
                last_val = i;
                continue;
            }
            catch (InvalidParamException ipe) {
                // empty catch block
            }
        }
        expression.reset();
        while (last_val >= 0) {
            expression.next();
            --last_val;
        }
        return bg_pos.get();
    }

    public CssBackgroundValue check(ApplContext ac, CssExpression expression, boolean check2, boolean is_final) throws InvalidParamException {
        CssBackgroundValue v = new CssBackgroundValue();
        boolean next_is_size = false;
        boolean got_size = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 3: {
                    if (v.color != null || next_is_size || !is_final) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    CssExpression exp = new CssExpression();
                    exp.addValue(val);
                    CssBackgroundColor bg_color = new CssBackgroundColor(ac, exp, check2);
                    v.color = (CssValue)bg_color.get();
                    break;
                }
                case 2: {
                    if (v.bg_image != null || next_is_size) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    CssExpression exp = new CssExpression();
                    exp.addValue(val);
                    CssBackgroundImage bg_image = new CssBackgroundImage(ac, exp, check2);
                    Object res = bg_image.get();
                    if (res instanceof CssValue) {
                        v.bg_image = (CssValue)res;
                        break;
                    }
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                case 4: 
                case 5: 
                case 6: {
                    Object res;
                    if (next_is_size) {
                        if (v.bg_size != null) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        res = this.getCssBackgroundSizeValue(ac, expression, check2);
                        op = expression.getOperator();
                        if (!(res instanceof CssValue)) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        v.bg_size = (CssValue)res;
                        got_size = true;
                        next_is_size = false;
                        break;
                    }
                    if (got_size) {
                        throw new InvalidParamException("bg_order", val, this.getPropertyName(), ac);
                    }
                    if (v.bg_position != null) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    res = this.getCssBackgroundPositionValue(ac, expression, check2);
                    op = expression.getOperator();
                    if (res instanceof CssValue) {
                        v.bg_position = (CssValue)res;
                        break;
                    }
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                case 0: {
                    Object res;
                    CssBackgroundImage bg_image;
                    CssBackgroundColor bg_color;
                    CssExpression exp;
                    CssIdent ident_val = (CssIdent)val;
                    if (CssBackgroundAttachment.isMatchingIdent(ident_val)) {
                        if (v.attachment != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        CssBackgroundAttachment attachment = new CssBackgroundAttachment(ac, exp, check2);
                        res = attachment.get();
                        if (res instanceof CssValue) {
                            v.attachment = (CssValue)res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (CssBackgroundImage.isMatchingIdent(ident_val)) {
                        if (v.bg_image != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        bg_image = new CssBackgroundImage(ac, exp, check2);
                        res = bg_image.get();
                        if (res instanceof CssValue) {
                            v.bg_image = (CssValue)res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (CssBackgroundOrigin.isMatchingIdent(ident_val)) {
                        if (v.origin != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        CssBackgroundOrigin origin = new CssBackgroundOrigin(ac, exp, check2);
                        res = origin.get();
                        if (res instanceof CssValue) {
                            v.origin = (CssValue)res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (CssBackgroundRepeat.isMatchingIdent(ident_val)) {
                        if (v.repeat_style != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        res = this.getCssBackgroundRepeatValue(ac, expression, check2);
                        op = expression.getOperator();
                        if (res instanceof CssValue) {
                            v.repeat_style = (CssValue)res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (next_is_size) {
                        if (CssBackgroundSize.isMatchingIdent(ident_val)) {
                            if (v.bg_size != null) {
                                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                            }
                            res = this.getCssBackgroundSizeValue(ac, expression, check2);
                            op = expression.getOperator();
                            if (!(res instanceof CssValue)) {
                                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                            }
                            v.bg_size = (CssValue)res;
                            got_size = true;
                            next_is_size = false;
                            break;
                        }
                    } else if (CssBackgroundPosition.isMatchingIdent(ident_val)) {
                        if (got_size) {
                            throw new InvalidParamException("bg_order", val, this.getPropertyName(), ac);
                        }
                        if (v.bg_position != null) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        res = this.getCssBackgroundPositionValue(ac, expression, check2);
                        op = expression.getOperator();
                        if (res instanceof CssValue) {
                            v.bg_position = (CssValue)res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (is_final) {
                        if (v.color != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        bg_color = new CssBackgroundColor(ac, exp, check2);
                        v.color = (CssValue)bg_color.get();
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            if (op == '/') {
                next_is_size = true;
            } else if (op != ' ') {
                throw new InvalidParamException("operator", val, this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.align_bg_values(v);
        return v;
    }

    private void align_bg_values(CssBackgroundValue v) {
        Object value;
        if (v.bg_image == null) {
            value = new CssBackgroundImage().get();
            if (value instanceof CssValue) {
                v.bg_image_value = (CssValue)value;
            }
        } else {
            v.bg_image_value = v.bg_image;
        }
        if (v.bg_position == null) {
            value = new CssBackgroundPosition().get();
            if (value instanceof CssValue) {
                v.bg_position_value = (CssValue)value;
            }
        } else {
            v.bg_position_value = v.bg_position;
        }
        if (v.bg_size == null) {
            value = new CssBackgroundSize().get();
            if (value instanceof CssValue) {
                v.bg_size_value = (CssValue)value;
            }
        } else {
            v.bg_size_value = v.bg_size;
        }
        if (v.repeat_style == null) {
            value = new CssBackgroundRepeat().get();
            if (value instanceof CssValue) {
                v.repeat_style_value = (CssValue)value;
            }
        } else {
            v.repeat_style_value = v.repeat_style;
        }
        if (v.attachment == null) {
            value = new CssBackgroundAttachment().get();
            if (value instanceof CssValue) {
                v.attachment_value = (CssValue)value;
            }
        } else {
            v.attachment_value = v.attachment;
        }
        if (v.origin == null) {
            value = new CssBackgroundOrigin().get();
            if (value instanceof CssValue) {
                CssValue css_val = (CssValue)value;
                v.origin_value = (CssValue)value;
                if (css_val.getType() == 0 && CssBackgroundClip.isMatchingIdent((CssIdent)css_val)) {
                    v.clip_value = v.origin_value;
                }
            }
        } else {
            v.origin_value = v.origin;
        }
        v.color_value = v.color == null ? new CssBackgroundColor().getColor() : v.color;
    }

    private void transform_into_individual_values() {
        if (this.value instanceof CssBackgroundValue) {
            CssBackgroundValue v = (CssBackgroundValue)this.value;
            if (v.color != null) {
                this.color = new CssBackgroundColor();
                this.color.set(v.color_value);
            }
            if (v.bg_image != null) {
                this.image = new CssBackgroundImage();
                this.image.set(v.bg_image_value);
            }
            if (v.repeat_style != null) {
                this.repeat = new CssBackgroundRepeat();
                this.repeat.set(v.repeat_style_value);
            }
            if (v.attachment != null) {
                this.attachment = new CssBackgroundAttachment();
                this.attachment.set(v.attachment_value);
            }
            if (v.bg_position != null) {
                this.position = new CssBackgroundPosition();
                this.position.set(v.bg_position_value);
            }
            if (v.bg_size != null) {
                this.size = new CssBackgroundSize();
                this.size.set(v.bg_size_value);
            }
        } else if (this.value instanceof ArrayList) {
            ArrayList vlist = (ArrayList)this.value;
            int len = vlist.size();
            ArrayList<CssValue> images = new ArrayList<CssValue>(len);
            ArrayList<CssValue> repeats = new ArrayList<CssValue>(len);
            ArrayList<CssValue> positions = new ArrayList<CssValue>(len);
            ArrayList<CssValue> attachments = new ArrayList<CssValue>(len);
            ArrayList<CssValue> sizes = new ArrayList<CssValue>(len);
            for (int i = 0; i < len; ++i) {
                CssBackgroundValue v = (CssBackgroundValue)vlist.get(i);
                images.add(v.bg_image_value);
                repeats.add(v.repeat_style_value);
                positions.add(v.bg_position_value);
                attachments.add(v.attachment_value);
                sizes.add(v.bg_size_value);
                if (v.color == null) continue;
                this.color = new CssBackgroundColor();
                this.color.set(v.color_value);
            }
            this.image = new CssBackgroundImage();
            this.image.set(images);
            this.repeat = new CssBackgroundRepeat();
            this.repeat.set(repeats);
            this.attachment = new CssBackgroundAttachment();
            this.attachment.set(attachments);
            this.position = new CssBackgroundPosition();
            this.position.set(sizes);
            this.size = new CssBackgroundSize();
            this.size.set(sizes);
        } else {
            this.image = null;
            this.repeat = null;
            this.attachment = null;
            this.color = null;
            this.size = null;
            this.position = null;
        }
    }

    public CssBackgroundImage getImage() {
        return this.image;
    }

    public Object get() {
        return this.color;
    }

    public CssValue getColor() {
        if (this.color == null) {
            return null;
        }
        return this.color.getColor();
    }

    public final String getPropertyName() {
        return propertyName;
    }

    public String toString() {
        if (this.value instanceof ArrayList) {
            ArrayList v_list = (ArrayList)this.value;
            StringBuilder sb = new StringBuilder();
            for (Object val : v_list) {
                sb.append(val.toString()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            return sb.toString();
        }
        return this.value.toString();
    }

    public void setImportant() {
        super.setImportant();
        if (this.color != null) {
            this.color.important = true;
        }
        if (this.image != null) {
            this.image.important = true;
        }
        if (this.repeat != null) {
            this.repeat.important = true;
        }
        if (this.attachment != null) {
            this.attachment.important = true;
        }
        if (this.position != null) {
            this.position.important = true;
        }
        if (this.size != null) {
            this.size.important = true;
        }
    }

    public void print(CssPrinterStyle printer) {
        if (!(this.color == null || this.image == null || this.repeat == null || this.attachment == null || this.position == null || this.size == null || !this.getImportant() && (this.image.important || this.color.important || this.repeat.important || this.attachment.important || this.size.important || this.position.important))) {
            if (this.color.byUser || this.image.byUser || this.repeat.byUser || this.attachment.byUser || this.size.byUser || this.position.byUser) {
                printer.print(this);
            }
        } else {
            if (this.color != null) {
                this.color.print(printer);
            }
            if (this.image != null) {
                this.image.print(printer);
            }
            if (this.repeat != null) {
                this.repeat.print(printer);
            }
            if (this.attachment != null) {
                this.attachment.print(printer);
            }
            if (this.position != null) {
                this.position.print(printer);
            }
            if (this.size != null) {
                this.size.print(printer);
            }
        }
    }

    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.color != null) {
            this.color.setSelectors(selector);
        }
        if (this.image != null) {
            this.image.setSelectors(selector);
        }
        if (this.repeat != null) {
            this.repeat.setSelectors(selector);
        }
        if (this.attachment != null) {
            this.attachment.setSelectors(selector);
        }
        if (this.position != null) {
            this.position.setSelectors(selector);
        }
        if (this.size != null) {
            this.size.setSelectors(selector);
        }
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        ((Css1Style)style).cssBackground.same = this.same;
        ((Css1Style)style).cssBackground.byUser = this.byUser;
        if (this.color != null) {
            this.color.addToStyle(ac, style);
        }
        if (this.image != null) {
            this.image.addToStyle(ac, style);
        }
        if (this.repeat != null) {
            this.repeat.addToStyle(ac, style);
        }
        if (this.attachment != null) {
            this.attachment.addToStyle(ac, style);
        }
        if (this.position != null) {
            this.position.addToStyle(ac, style);
        }
        if (this.size != null) {
            this.size.addToStyle(ac, style);
        }
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackground();
        }
        return ((Css1Style)style).cssBackground;
    }

    public boolean equals(CssProperty property) {
        return false;
    }

    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.color != null) {
            this.color.setInfo(line, source);
        }
        if (this.image != null) {
            this.image.setInfo(line, source);
        }
        if (this.repeat != null) {
            this.repeat.setInfo(line, source);
        }
        if (this.attachment != null) {
            this.attachment.setInfo(line, source);
        }
        if (this.position != null) {
            this.position.setInfo(line, source);
        }
        if (this.size != null) {
            this.size.setInfo(line, source);
        }
    }

    public class CssBackgroundValue
    extends CssValueList {
        CssValue bg_image = null;
        CssValue bg_position = null;
        CssValue bg_size = null;
        CssValue repeat_style = null;
        CssValue attachment = null;
        CssValue origin = null;
        CssValue color = null;
        CssValue bg_image_value = null;
        CssValue bg_position_value = null;
        CssValue bg_size_value = null;
        CssValue repeat_style_value = null;
        CssValue attachment_value = null;
        CssValue origin_value = null;
        CssValue clip_value = null;
        CssValue color_value = null;

        public boolean equals(CssBackgroundValue v) {
            if (this.bg_image_value == null ? v.bg_image_value != null : !this.bg_image_value.equals(v.bg_image_value)) {
                return false;
            }
            if (this.bg_position_value == null ? v.bg_position_value != null : !this.bg_position_value.equals(v.bg_position_value)) {
                return false;
            }
            if (this.bg_size_value == null ? v.bg_size_value != null : !this.bg_size_value.equals(v.bg_size_value)) {
                return false;
            }
            if (this.repeat_style_value == null ? v.repeat_style_value != null : !this.repeat_style_value.equals(v.repeat_style_value)) {
                return false;
            }
            if (this.attachment_value == null ? v.attachment_value != null : !this.attachment_value.equals(v.attachment_value)) {
                return false;
            }
            if (this.origin_value == null ? v.origin_value != null : !this.origin_value.equals(v.origin_value)) {
                return false;
            }
            if (this.clip_value == null ? v.clip_value != null : !this.clip_value.equals(v.clip_value)) {
                return false;
            }
            return !(this.color_value == null ? v.color_value != null : !this.color_value.equals(v.color_value));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.bg_image != null) {
                sb.append(this.bg_image).append(' ');
            }
            if (this.bg_position != null) {
                sb.append(this.bg_position).append(' ');
            }
            if (this.bg_size != null) {
                sb.append('/').append(this.bg_size).append(' ');
            }
            if (this.repeat_style != null) {
                sb.append(this.repeat_style).append(' ');
            }
            if (this.attachment != null) {
                sb.append(this.attachment).append(' ');
            }
            if (this.origin != null) {
                sb.append(this.origin).append(' ');
            }
            if (this.color != null) {
                sb.append(this.color);
            } else {
                int sb_length = sb.length();
                if (sb_length > 0) {
                    sb.setLength(sb_length - 1);
                }
            }
            return sb.toString();
        }
    }
}

