/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.aural;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.aural.ACssPause;
import org.w3c.css.properties.aural.ACssPauseBefore;
import org.w3c.css.properties.aural.ACssProperties;
import org.w3c.css.properties.aural.ACssProperty;
import org.w3c.css.properties.aural.ACssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;

public class ACssPauseAfter
extends ACssProperty {
    CssValue value;
    private static CssTime defaultValue;

    public ACssPauseAfter() {
        if (defaultValue == null) {
            defaultValue = new CssTime(ACssProperties.getValue(this, "default"));
        }
        this.value = defaultValue;
    }

    public ACssPauseAfter(ACssPauseBefore pauseBefore) {
        this.value = pauseBefore.value;
    }

    public ACssPauseAfter(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val.equals(inherit)) {
            this.value = inherit;
            expression.next();
            return;
        }
        if (val instanceof CssPercentage) {
            float num = ((Float)val.get()).floatValue();
            if (num < 0.0f) {
                throw new InvalidParamException("negative-value", val.toString(), ac);
            }
            this.value = val;
            expression.next();
            return;
        }
        if (val instanceof CssTime) {
            float num = ((Float)val.get()).floatValue();
            if (num < 0.0f) {
                throw new InvalidParamException("negative-value", val.toString(), ac);
            }
            this.value = val;
            expression.next();
            return;
        }
        if (val instanceof CssNumber) {
            this.value = ((CssNumber)val).getTime();
            expression.next();
        }
        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
    }

    public ACssPauseAfter(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public int getValue() {
        return ((Float)this.value.get()).intValue();
    }

    public boolean isSoftlyInherited() {
        return this.value == inherit;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public String getPropertyName() {
        return "pause-after";
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        ACssPause acssPause = ((ACssStyle)style).acssPause;
        if (acssPause.pauseAfter != null) {
            style.addRedefinitionWarning(ac, this);
        }
        acssPause.pauseAfter = this;
    }

    public boolean equals(CssProperty property) {
        if (this.value != null) {
            return property instanceof ACssPauseAfter && this.value.equals(((ACssPauseAfter)property).value);
        }
        return false;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ACssStyle)style).getPauseAfter();
        }
        return ((ACssStyle)style).acssPause.pauseAfter;
    }
}

