/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.util.ArrayList;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleFontFace;
import org.w3c.css.parser.AtRulePage;
import org.w3c.css.parser.CssSelectorsConstant;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.selectors.AdjacentSiblingSelector;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ChildSelector;
import org.w3c.css.selectors.DescendantSelector;
import org.w3c.css.selectors.GeneralSiblingSelector;
import org.w3c.css.selectors.PseudoClassSelector;
import org.w3c.css.selectors.PseudoElementSelector;
import org.w3c.css.selectors.PseudoFactory;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.SelectorsList;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Messages;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warnings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssSelectors
extends SelectorsList
implements CssSelectorsConstant {
    ApplContext ac;
    AtRule atRule;
    String element;
    char connector = (char)32;
    protected CssSelectors next;
    private boolean isBlock;
    CssStyle properties;
    private int hashElement;
    private static Class style;
    private boolean Init;
    private String cachedRepresentation = null;
    private boolean isFinal = false;

    public CssSelectors(ApplContext ac) {
        super(ac);
        style = ac.getCssSelectorsStyle();
        try {
            this.properties = (CssStyle)style.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ac = ac;
    }

    private CssSelectors(Class style) {
        CssSelectors.style = style;
        try {
            this.properties = (CssStyle)style.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ac = null;
    }

    public CssSelectors(CssSelectors next) {
        this(style);
        this.next = next;
    }

    public CssSelectors(ApplContext ac, CssSelectors next) {
        this(ac);
        this.next = next;
    }

    public void setStyle(Class style0) {
        Util.verbose("Style is : " + style0);
        style = style0;
    }

    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    public final AtRule getAtRule() {
        return this.atRule;
    }

    public final String getElement() {
        return this.element;
    }

    public final boolean isBlockLevelElement() {
        return this.isBlock;
    }

    public void addPseudoClass(String pseudo) throws InvalidParamException {
        int i;
        String[] ps;
        if (pseudo == null) {
            return;
        }
        String profile = this.ac.getProfile();
        if (profile == null || profile.equals("") || profile.equals("none")) {
            profile = this.ac.getCssVersion();
        }
        if ((ps = PseudoFactory.getPseudoClass(profile)) != null) {
            for (i = 0; i < ps.length; ++i) {
                if (!pseudo.equals(ps[i])) continue;
                this.addPseudoClass(new PseudoClassSelector(pseudo));
                return;
            }
        }
        if ((ps = PseudoFactory.getPseudoElementExceptions(profile)) != null) {
            for (i = 0; i < ps.length; ++i) {
                if (!pseudo.equals(ps[i])) continue;
                this.addPseudoClass(new PseudoClassSelector(pseudo));
                return;
            }
        }
        throw new InvalidParamException("pseudo", ":" + pseudo, this.ac);
    }

    public void addPseudoElement(String pseudo) throws InvalidParamException {
        String[] ps;
        if (pseudo == null) {
            return;
        }
        String profile = this.ac.getProfile();
        if (profile == null || profile.equals("") || profile.equals("none")) {
            profile = this.ac.getCssVersion();
        }
        if ((ps = PseudoFactory.getPseudoElement(profile)) != null) {
            for (int i = 0; i < ps.length; ++i) {
                if (!pseudo.equals(ps[i])) continue;
                this.addPseudoElement(new PseudoElementSelector(pseudo));
                return;
            }
        }
        throw new InvalidParamException("pseudo", "::" + pseudo, this.ac);
    }

    public void setPseudoFun(String pseudo, String param) throws InvalidParamException {
        String[] ps;
        String profile = this.ac.getProfile();
        if (profile == null || profile.equals("") || profile.equals("none")) {
            profile = this.ac.getCssVersion();
        }
        if ((ps = PseudoFactory.getPseudoFunction(profile)) != null) {
            for (int i = 0; i < ps.length; ++i) {
                if (!pseudo.equals(ps[i])) continue;
                this.addPseudoFunction(PseudoFactory.newPseudoFunction(pseudo, param, this.ac));
                return;
            }
            throw new InvalidParamException("pseudo", ":" + pseudo, this.ac);
        }
    }

    @Override
    public void addType(TypeSelector type) throws InvalidParamException {
        super.addType(type);
        this.element = type.getName();
        this.hashElement = this.element.hashCode();
    }

    @Override
    public void addDescendant(DescendantSelector descendant) throws InvalidParamException {
        super.addDescendant(descendant);
        this.connector = (char)32;
    }

    @Override
    public void addChild(ChildSelector child) throws InvalidParamException {
        super.addChild(child);
        this.connector = (char)62;
    }

    @Override
    public void addAdjacentSibling(AdjacentSiblingSelector adjacent) throws InvalidParamException {
        super.addAdjacentSibling(adjacent);
        this.connector = (char)43;
    }

    @Override
    public void addGeneralSibling(GeneralSiblingSelector sibling) throws InvalidParamException {
        super.addGeneralSibling(sibling);
        this.connector = (char)126;
    }

    @Override
    public void addAttribute(AttributeSelector attribute) throws InvalidParamException {
        int _s = this.size();
        for (int i = 0; i < _s; ++i) {
            Selector s = this.getSelector(i);
            if (!(s instanceof AttributeSelector)) continue;
            ((AttributeSelector)s).applyAttribute(this.ac, attribute);
        }
        super.addAttribute(attribute);
    }

    public void addProperty(CssProperty property, Warnings warnings) {
        this.Init = true;
        if (this.properties != null) {
            this.properties.setProperty(this.ac, property, warnings);
        } else {
            System.err.println("[ERROR] Invalid state in org.w3c.css.parser.CssSelectors#addProperty");
            System.err.println("[ERROR] Please report BUG");
        }
    }

    public CssStyle getStyle() {
        return this.properties;
    }

    @Override
    public String toString() {
        if (this.isToStringCached()) {
            return this.cachedRepresentation;
        }
        StringBuilder sbrep = new StringBuilder();
        if (this.next != null) {
            sbrep.append(this.next.toString());
        }
        sbrep.append(super.toString());
        this.cachedRepresentation = sbrep.toString();
        return this.cachedRepresentation;
    }

    public String getEscaped() {
        return Messages.escapeString(this.toString());
    }

    @Override
    public boolean isToStringCached() {
        if (this.cachedRepresentation == null) {
            return false;
        }
        if (this.isFinal) {
            return true;
        }
        if (this.next != null) {
            return super.isToStringCached() && this.next.isToStringCached();
        }
        return super.isToStringCached();
    }

    public void markAsFinal() {
        if (!this.isFinal) {
            if (!this.isToStringCached()) {
                this.cachedRepresentation = null;
                if (this.next != null) {
                    this.next.markAsFinal();
                }
            }
            this.isFinal = true;
        }
    }

    public boolean equals(Object selector) {
        if (selector == null || !(selector instanceof CssSelectors)) {
            return false;
        }
        CssSelectors s = (CssSelectors)selector;
        if (this.atRule instanceof AtRulePage || this.atRule instanceof AtRuleFontFace) {
            return this.atRule.equals(s.atRule);
        }
        if (this.hashCode() == s.hashCode()) {
            if (this.atRule == null) {
                return s.getAtRule() == null;
            }
            return this.atRule.canApply(s.getAtRule());
        }
        return false;
    }

    public void setNext(CssSelectors next) {
        this.next = next;
        this.Invalidate();
    }

    public CssSelectors getNext() {
        return this.next;
    }

    public boolean isEmpty() {
        return !this.Init;
    }

    public void addAttribute(String attName, String value) throws InvalidParamException {
        if (this.ac.getProfile() != null && !"".equals(this.ac.getProfile())) {
            if (this.ac.getProfile().equals("mobile")) {
                throw new InvalidParamException("notformobile", "attributes", this.ac);
            }
        } else {
            this.addAttribute(new AttributeExact(attName, value));
            this.Invalidate();
        }
    }

    void Invalidate() {
        this.setSpecificity(0);
        if (this.Init) {
            try {
                this.properties = (CssStyle)style.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    final boolean canApply(ArrayList<Selector> attrs, ArrayList<Selector> attrs2) {
        if (attrs.size() > 0) {
            for (int i = 0; i < attrs.size(); ++i) {
                Selector selector = attrs.get(i);
                Selector other = null;
                for (int j = 0; j < attrs2.size() && !(other = attrs2.get(j)).equals(selector); ++j) {
                    other = null;
                }
                if (other != null) {
                    if (selector.canApply(other)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean canApply(CssSelectors selector) {
        if (this.atRule instanceof AtRulePage || this.atRule instanceof AtRuleFontFace) {
            return this.atRule.canApply(selector.atRule);
        }
        Util.verbose(this.getSpecificity() + " canApply this " + this + " selector: " + selector);
        Util.verbose("connector " + this.connector);
        Util.verbose(this.getSelectors().toString());
        Util.verbose(selector.getSelectors().toString());
        if (this.hashElement != selector.hashElement && this.hashElement != 0) {
            Util.verbose("canApply RETURNS FALSE");
            return false;
        }
        if (this.next == null || selector.next == null) {
            boolean result = this.canApply(this.getSelectors(), selector.getSelectors());
            Util.verbose("canApply RETURNS " + result);
            return result;
        }
        return this.next.canMatch(selector.next);
    }

    private boolean canMatch(CssSelectors selector) {
        boolean result = this.canApply(this.getSelectors(), selector.getSelectors());
        Util.verbose("canMatched this " + this + " selector: " + selector);
        Util.verbose("connector " + this.connector);
        Util.verbose(this.getSelectors().toString());
        Util.verbose(selector.getSelectors().toString());
        Util.verbose("canMatched for attributes :" + result);
        if (this.hashElement != selector.hashElement && this.hashElement != 0) {
            if (this.connector == ' ' && selector.next != null) {
                return this.canMatch(selector.next);
            }
            Util.verbose("canMatched RETURN FALSE");
            return false;
        }
        if (this.next == null || selector.next == null) {
            Util.verbose("canMatched RETURN " + result);
            return this.canApply(this.getSelectors(), selector.getSelectors());
        }
        return this.next.canMatch(selector.next);
    }

    public void findConflicts(ApplContext ac, Warnings warnings, CssSelectors[] allSelectors) {
        CssStyle style = this.getStyle();
        style.findConflicts(ac, warnings, this, allSelectors);
    }
}

