/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.util.Enumeration;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleMedia;
import org.w3c.css.parser.MediaEnumeration;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;

public class AtRuleMediaCSS2
extends AtRuleMedia {
    static final String[] mediaCSS2 = new String[]{"all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "tty", "tv", "presentation"};
    String[] media = new String[mediaCSS2.length];
    boolean empty = true;

    public AtRuleMedia addMedia(String medium, ApplContext ac) throws InvalidParamException {
        for (int i = 0; i < mediaCSS2.length; ++i) {
            if (!medium.equals(mediaCSS2[i])) continue;
            this.media[i] = mediaCSS2[i];
            this.empty = false;
            return this;
        }
        throw new InvalidParamException("media", medium, ac);
    }

    public String keyword() {
        return "media";
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean canApply(AtRule atRule) {
        if (atRule instanceof AtRuleMedia) {
            AtRuleMedia second = (AtRuleMedia)atRule;
            for (int i = 0; i < this.media.length; ++i) {
                if (this.media[i] == second.media[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canMatched(AtRule atRule) {
        if (atRule instanceof AtRuleMedia) {
            AtRuleMedia second = (AtRuleMedia)atRule;
            for (int i = 0; i < this.media.length; ++i) {
                if (this.media[i] != second.media[i]) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration elements() {
        return new MediaEnumeration(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@");
        boolean first = true;
        sb.append(this.keyword());
        for (int i = 0; i < this.media.length; ++i) {
            if (this.media[i] == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.media[i]);
        }
        return sb.toString();
    }
}

