/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.css.TagSoupStyleSheetHandler;
import org.w3c.css.css.XMLStyleSheetHandler;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.Util;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public final class DocumentParser {
    private StyleSheet style;
    private URL htmlURL;
    private Exception exception;
    private ApplContext ac;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentParser(ApplContext ac, String urlString) throws Exception {
        this.htmlURL = HTTPURL.getURL(urlString);
        this.ac = ac;
        urlString = this.htmlURL.toString();
        String urlLower = urlString.toLowerCase();
        String media = ac.getMedium();
        String urlProtocol = this.htmlURL.getProtocol();
        if (!"http".equals(urlProtocol) && !"https".equals(urlProtocol)) {
            if (urlLower.endsWith(".css")) {
                StyleSheetParser parser = new StyleSheetParser();
                parser.parseURL(ac, this.htmlURL, null, null, media, 3);
                this.style = parser.getStyleSheet();
                return;
            } else if (urlLower.endsWith(".html") || urlLower.endsWith(".shtml") || urlLower.endsWith("/")) {
                TagSoupStyleSheetHandler handler = new TagSoupStyleSheetHandler(this.htmlURL, ac);
                handler.parse(this.htmlURL);
                this.style = handler.getStyleSheet();
                if (this.style == null) return;
                this.style.setType("text/html");
                return;
            } else {
                if (!urlLower.endsWith(".xhtml") && !urlLower.endsWith(".xml")) throw new Exception("Unknown file");
                XMLStyleSheetHandler handler = new XMLStyleSheetHandler(this.htmlURL, ac);
                handler.parse(this.htmlURL);
                this.style = handler.getStyleSheet();
                if (this.style == null) return;
                this.style.setType("text/xml");
            }
            return;
        }
        URLConnection connection = null;
        try {
            String cType;
            boolean isXML = false;
            String credential = ac.getCredential();
            connection = HTTPURL.getConnection(this.htmlURL, ac);
            this.htmlURL = connection.getURL();
            String httpCL = connection.getHeaderField("Content-Location");
            if (httpCL != null) {
                this.htmlURL = HTTPURL.getURL(this.htmlURL, httpCL);
            }
            if ((cType = connection.getContentType()) == null) {
                cType = "unknown/unknown";
            }
            MimeType contentType = null;
            try {
                contentType = new MimeType(cType);
            }
            catch (MimeTypeFormatException ex) {
                // empty catch block
            }
            if (Util.onDebug) {
                System.err.println("[DEBUG] content type is [" + contentType + ']');
            }
            if (contentType.match(MimeType.TEXT_HTML) == 4) {
                TagSoupStyleSheetHandler handler = new TagSoupStyleSheetHandler(this.htmlURL, ac);
                handler.parse(urlString, connection);
                this.style = handler.getStyleSheet();
                if (this.style == null) return;
                this.style.setType("text/html");
                return;
            } else if (contentType.match(MimeType.TEXT_CSS) == 4) {
                StyleSheetParser parser = new StyleSheetParser();
                parser.parseURL(ac, this.htmlURL, null, null, media, 3);
                this.style = parser.getStyleSheet();
                return;
            } else {
                if (contentType.match(MimeType.TEXT_XML) != 4 && contentType.match(MimeType.APPLICATION_XHTML_XML) != 4) throw new IOException("Unknown mime type : " + contentType);
                XMLStyleSheetHandler handler = new XMLStyleSheetHandler(this.htmlURL, ac);
                handler.parse(urlString, connection);
                this.style = handler.getStyleSheet();
                if (this.style == null) return;
                this.style.setType("text/xml");
                return;
            }
        }
        finally {
            try {
                connection.getInputStream().close();
            }
            catch (Exception e) {}
        }
    }

    public StyleSheet getStyleSheet() {
        return this.style;
    }
}

