/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.util.Enumeration;
import org.w3c.css.css.CompareExplicitWeight;
import org.w3c.css.css.CompareOrderSpecified;
import org.w3c.css.css.CompareSpecificity;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.QuickSortAlgorithm;
import org.w3c.css.util.SortAlgorithm;
import org.w3c.css.util.Util;

public final class CssCascadingOrder {
    CssProperty[] propertyData;
    int propertyCount;
    final int capacityIncrement = 10;

    public CssProperty order(CssProperty property, StyleSheet style, CssSelectors selector) {
        CssStyle s;
        this.propertyData = new CssProperty[10];
        this.propertyCount = 0;
        Util.verbose("CASCADING ORDER " + property.getPropertyName() + " in " + selector);
        Enumeration e = style.getRules().elements();
        while (e.hasMoreElements()) {
            CssSelectors context = (CssSelectors)e.nextElement();
            Util.verbose("######## test with " + context + " and " + selector);
            if (!context.canApply(selector)) continue;
            CssProperty prop = property.getPropertyInStyle(context.getStyle(), false);
            Util.verbose("%%%%%%%%%%%%%%%%% Found " + context);
            if (prop == null) continue;
            this.addProperty(prop);
        }
        if (this.propertyCount == 0) {
            if (selector.getNext() != null && property.inherited()) {
                Util.verbose("Found nothing ... try the next " + selector.getNext());
                s = style.getStyle(selector.getNext());
                property = property.getPropertyInStyle(s, true);
            }
        } else {
            Util.verbose("@@@@@@@@@@@@@@ FOUND " + this.propertyCount + " properties");
            property = this.getProperty(selector);
            if (property.isSoftlyInherited() && selector.getNext() != null) {
                s = style.getStyle(selector.getNext());
                property = property.getPropertyInStyle(s, true);
            }
        }
        property = property.duplicate();
        property.setSelectors(selector);
        return property;
    }

    private CssProperty getProperty(CssSelectors selector) {
        int end;
        QuickSortAlgorithm sort = new QuickSortAlgorithm();
        ((SortAlgorithm)sort).sort(this.propertyData, 0, this.propertyCount - 1, new CompareExplicitWeight());
        int old = this.propertyData[0].getExplicitWeight();
        for (end = 0; end < this.propertyCount && this.propertyData[end].getExplicitWeight() == old; ++end) {
        }
        ((SortAlgorithm)sort).sort(this.propertyData, 0, end - 1, new CompareSpecificity());
        old = this.propertyData[0].getSelectors().getSpecificity();
        for (end = 0; end < this.propertyCount && this.propertyData[end].getSelectors().getSpecificity() == old; ++end) {
        }
        ((SortAlgorithm)sort).sort(this.propertyData, 0, end - 1, new CompareOrderSpecified());
        return this.propertyData[0];
    }

    private final void addProperty(CssProperty property) {
        int oldCapacity = this.propertyData.length;
        if (this.propertyCount + 1 > oldCapacity) {
            CssProperty[] oldData = this.propertyData;
            this.propertyData = new CssProperty[oldCapacity + 10];
            System.arraycopy(oldData, 0, this.propertyData, 0, this.propertyCount);
        }
        this.propertyData[this.propertyCount++] = property;
    }
}

