/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.vx68k.bitbucket.api.BitbucketBranch;
import org.vx68k.bitbucket.api.client.BitbucketClient;
import org.vx68k.bitbucket.api.client.BitbucketClientCommit;
import org.vx68k.bitbucket.api.client.BitbucketClientRef;

public class BitbucketClientBranch
extends BitbucketClientRef
implements BitbucketBranch {
    protected static List<BitbucketClientCommit> parseCommits(JsonArray commitsArray) {
        ArrayList<BitbucketClientCommit> commits = null;
        if (commitsArray != null) {
            commits = new ArrayList<BitbucketClientCommit>();
            for (JsonValue value : commitsArray) {
                commits.add(new BitbucketClientCommit((JsonObject)value));
            }
        }
        return commits;
    }

    public BitbucketClientBranch(JsonObject jsonObject) {
        this(jsonObject, null);
    }

    public BitbucketClientBranch(JsonObject jsonObject, BitbucketClient bitbucketClient) {
        super(jsonObject, bitbucketClient);
        String type = this.getType();
        if (!("branch".equals(type) || "named_branch".equals(type) || "bookmark".equals(type))) {
            throw new IllegalArgumentException("JSON object is not branch, named_branch or bookmark");
        }
    }

    public final List<BitbucketClientCommit> getHeads() {
        JsonObject branchObject = this.getJsonObject();
        List<BitbucketClientCommit> heads = null;
        if (branchObject.containsKey((Object)"heads")) {
            heads = BitbucketClientBranch.parseCommits(branchObject.getJsonArray("heads"));
        }
        return heads;
    }
}

