/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import org.vx68k.bitbucket.api.Bitbucket;
import org.vx68k.bitbucket.api.BitbucketAccount;
import org.vx68k.bitbucket.api.BitbucketRepository;
import org.vx68k.bitbucket.api.client.BitbucketClientAccount;
import org.vx68k.bitbucket.api.client.BitbucketClientRepository;
import org.vx68k.bitbucket.api.client.BitbucketClientUser;
import org.vx68k.bitbucket.api.client.TokenRefreshListener;
import org.vx68k.bitbucket.api.client.internal.JsonMessageBodyReader;
import org.vx68k.bitbucket.api.client.internal.OAuth2Authenticator;

public class BitbucketClient
implements Bitbucket,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final URI API_BASE_URI = URI.create("https://api.bitbucket.org/2.0/");
    public static final URI AUTHORIZATION_ENDPOINT_URI = URI.create("https://bitbucket.org/site/oauth2/authorize");
    public static final URI TOKEN_ENDPOINT_URI = URI.create("https://bitbucket.org/site/oauth2/access_token");
    private static BitbucketClient defaultInstance = new BitbucketClient();
    private final ClientBuilder clientBuilder = ClientBuilder.newBuilder();
    private final OAuth2Authenticator authenticator = new OAuth2Authenticator(API_BASE_URI, TOKEN_ENDPOINT_URI);

    public BitbucketClient() {
        this.clientBuilder.register(JsonMessageBodyReader.class);
        this.clientBuilder.register((Object)this.authenticator);
    }

    public static BitbucketClient getDefaultInstance() {
        return defaultInstance;
    }

    public static void setDefaultInstance(BitbucketClient newValue) {
        defaultInstance = newValue;
    }

    public final String getClientId() {
        return this.authenticator.getClientId();
    }

    public final void setClientId(String newValue) {
        this.authenticator.setClientId(newValue);
    }

    public final void setClientSecret(String newValue) {
        this.authenticator.setClientSecret(newValue);
    }

    public final String getAccessToken() {
        return this.authenticator.getAccessToken();
    }

    public final void setAccessToken(String newValue) {
        this.authenticator.setAccessToken(newValue);
    }

    public final String getRefreshToken() {
        return this.authenticator.getRefreshToken();
    }

    public final void setRefreshToken(String newValue) {
        this.authenticator.setRefreshToken(newValue);
    }

    public final Instant getAccessTokenExpiry() {
        return this.authenticator.getAccessTokenExpiry();
    }

    public final void setAccessTokenExpiry(Instant newValue) {
        this.authenticator.setAccessTokenExpiry(newValue);
    }

    public final void addTokenRefreshListener(TokenRefreshListener listener) {
        this.authenticator.addTokenRefreshListener(listener);
    }

    public final void removeTokenRefreshListener(TokenRefreshListener listener) {
        this.authenticator.removeTokenRefreshListener(listener);
    }

    public final void loginWithAuthorizationCode(String code, URI redirectionUri) {
        Form form = new Form("grant_type", "authorization_code");
        form.param("code", code);
        if (redirectionUri != null) {
            form.param("redirect_uri", redirectionUri.toString());
        }
        this.authenticator.requestAccessToken(Entity.form((Form)form));
    }

    public final void login(String username, String password) {
        Form form = new Form("grant_type", "password");
        form.param("username", username);
        form.param("password", password);
        this.authenticator.requestAccessToken(Entity.form((Form)form));
    }

    public final void logout() {
        this.authenticator.setRefreshToken(null);
        this.authenticator.setAccessToken(null);
        this.authenticator.setAccessTokenExpiry(null);
    }

    public final JsonObject get(URI link) {
        String[] mediaTypes = new String[]{"application/json"};
        return this.get(link, mediaTypes, JsonObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T get(URI link, String[] mediaTypes, Class<T> type) {
        try (Client client = this.clientBuilder.build();){
            WebTarget target = client.target(link);
            Object object = target.request().accept(mediaTypes).get(type);
            return (T)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JsonObject post(URI uri, Entity<?> entity) {
        try (Client client = this.clientBuilder.build();){
            JsonObject jsonObject = (JsonObject)client.target(uri).request().accept(new String[]{"application/json"}).post(entity, JsonObject.class);
            return jsonObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JsonObject getResource(String path, Map<String, Object> values) {
        try (Client client = this.clientBuilder.build();){
            WebTarget target = client.target(API_BASE_URI).path(path);
            if (values != null) {
                target = target.resolveTemplates(values);
            }
            JsonObject jsonObject = (JsonObject)target.request().accept(new String[]{"application/json"}).get(JsonObject.class);
            return jsonObject;
        }
    }

    @Override
    public final BitbucketAccount getUser(String name) {
        Map<String, Object> values = Collections.singletonMap("name", name);
        JsonObject object = this.getResource("/users/{name}", values);
        BitbucketClientUser value = null;
        if (object != null) {
            value = new BitbucketClientUser(object, this);
        }
        return value;
    }

    @Override
    public final BitbucketAccount getTeam(String name) {
        Map<String, Object> values = Collections.singletonMap("name", name);
        JsonObject object = this.getResource("/teams/{name}", values);
        BitbucketClientAccount value = null;
        if (object != null) {
            value = new BitbucketClientAccount(object, this);
        }
        return value;
    }

    @Override
    public final BitbucketRepository getRepository(String ownerName, String name) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("owner", ownerName);
        values.put("name", name);
        JsonObject object = this.getResource("/repositories/{owner}/{name}", values);
        BitbucketClientRepository value = null;
        if (object != null) {
            value = new BitbucketClientRepository(object, this);
        }
        return value;
    }

    @Override
    public final Collection<BitbucketRepository> repositories(String ownerName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

