/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.patterns;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.patterns.PDPattern;
import org.verapdf.pd.patterns.PDShading;
import org.verapdf.tools.TypeConverter;

public class PDShadingPattern
extends PDPattern {
    private final PDResources resources;

    public PDShadingPattern(COSObject obj, PDResources resources) {
        super(obj);
        this.resources = resources;
    }

    @Override
    public int getPatternType() {
        return 2;
    }

    public PDShading getShading() {
        COSObject obj = this.getKey(ASAtom.SHADING);
        if (obj != null && obj.getType().isDictionaryBased()) {
            return new PDShading(obj, this.resources);
        }
        return null;
    }

    public double[] getMatrix() {
        double[] dArray;
        double[] res = TypeConverter.getRealArray(this.getKey(ASAtom.MATRIX), 6, "Matrix");
        if (res != null) {
            dArray = res;
        } else {
            double[] dArray2 = new double[6];
            dArray2[0] = 1.0;
            dArray2[1] = 0.0;
            dArray2[2] = 0.0;
            dArray2[3] = 1.0;
            dArray2[4] = 0.0;
            dArray = dArray2;
            dArray2[5] = 0.0;
        }
        return dArray;
    }

    public PDExtGState getExtGState() {
        COSObject obj = this.getKey(ASAtom.EXT_G_STATE);
        if (obj.getType() == COSObjType.COS_DICT) {
            return new PDExtGState(obj);
        }
        return null;
    }
}

