/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.encryption;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.cos.filters.COSFilterAESDecryptionDefault;
import org.verapdf.cos.filters.COSFilterRC4DecryptionDefault;
import org.verapdf.pd.encryption.PDCryptFilter;
import org.verapdf.pd.encryption.PDEncryption;
import org.verapdf.tools.EncryptionToolsRevision4;
import org.verapdf.tools.EncryptionToolsRevision5_6;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class StandardSecurityHandler {
    private static final Logger LOGGER = Logger.getLogger(StandardSecurityHandler.class.getCanonicalName());
    private final PDEncryption pdEncryption;
    private final COSObject id;
    private Boolean isPasswordCorrect;
    private byte[] encryptionKey;
    private final boolean isRC4Decryption;
    private ASAtom method;
    private final COSDocument document;

    public StandardSecurityHandler(PDEncryption pdEncryption, COSObject id, COSDocument document) {
        this.pdEncryption = pdEncryption != null ? pdEncryption : new PDEncryption();
        this.id = id;
        this.document = document;
        PDCryptFilter stdCrypt = this.pdEncryption.getStandardCryptFilter();
        if (stdCrypt != null) {
            this.method = stdCrypt.getMethod();
        }
        this.isRC4Decryption = this.isRC4Decryption();
    }

    public boolean authenticatePassword(String password) {
        byte[] o = this.getO();
        Long p = this.pdEncryption.getP();
        byte[] id = this.getID();
        Long revision = this.pdEncryption.getR();
        boolean encMetadata = this.pdEncryption.isEncryptMetadata();
        int length = this.pdEncryption.getLength();
        byte[] u = this.getU();
        if (o != null && p != null && id != null && revision != null && u != null) {
            try {
                if (revision <= 4L) {
                    this.encryptionKey = EncryptionToolsRevision4.authenticateUserPassword(password, o, p.intValue(), id, revision.intValue(), encMetadata, length, u);
                } else if (revision >= 5L) {
                    this.encryptionKey = EncryptionToolsRevision5_6.getFileEncryptionKey(password.getBytes(), o, u, this.getOE(), this.getUE(), revision);
                }
                this.isPasswordCorrect = this.encryptionKey != null;
                return this.isPasswordCorrect;
            }
            catch (GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Caught Security Exception while document decryption", e);
                this.isPasswordCorrect = false;
                return false;
            }
        }
        LOGGER.log(Level.FINE, "Can't authenticate password in encrypted PDF, something is null.");
        this.isPasswordCorrect = false;
        return false;
    }

    public byte[] getEncryptionKey() {
        if (this.isPasswordCorrect == null) {
            this.checkPassword();
        }
        if (!this.isPasswordCorrect.booleanValue()) {
            return null;
        }
        return this.encryptionKey;
    }

    public boolean checkPassword() {
        if (this.isPasswordCorrect != null) {
            return this.isPasswordCorrect;
        }
        if (StaticResources.getPassword() == null) {
            this.authenticatePassword("");
        } else if (!this.authenticatePassword(StaticResources.getPassword())) {
            LOGGER.log(Level.WARNING, "Your password for this document is incorrect.");
        }
        return this.isPasswordCorrect;
    }

    public void decryptString(COSString string, COSKey stringKey) throws IOException, GeneralSecurityException {
        byte[] stringBytes = StandardSecurityHandler.getBytesOfHexString(string);
        ASMemoryInStream stream = new ASMemoryInStream(stringBytes);
        ASBufferedInFilter filter = this.isRC4Decryption ? new COSFilterRC4DecryptionDefault(stream, stringKey, this.encryptionKey) : new COSFilterAESDecryptionDefault(stream, stringKey, this.encryptionKey, false, this.method);
        byte[] buf = new byte[2048];
        byte[] res = new byte[]{};
        ((ASInputStream)filter).reset();
        int read = ((ASInputStream)filter).read(buf, buf.length);
        while (read != -1) {
            res = ASBufferedInFilter.concatenate(res, res.length, buf, read);
            read = ((ASInputStream)filter).read(buf, buf.length);
        }
        ((ASInputStream)filter).close();
        string.set(res);
    }

    public void decryptStream(COSStream stream, COSKey key) throws IOException, GeneralSecurityException {
        if (this.decryptRequired(stream)) {
            ASInputStream encStream = stream.getData();
            ASBufferedInFilter filter = this.isRC4Decryption ? new COSFilterRC4DecryptionDefault(encStream, key, this.encryptionKey) : new COSFilterAESDecryptionDefault(encStream, key, this.encryptionKey, true, this.method);
            this.document.addFileResource(new ASFileStreamCloser(filter));
            stream.setData(filter, COSStream.FilterFlags.RAW_DATA);
        }
    }

    private boolean decryptRequired(COSStream stream) {
        boolean res = true;
        List<ASAtom> filters = stream.getFilters().getFilters();
        for (int i = 0; i < filters.size(); ++i) {
            if (ASAtom.CRYPT != filters.get(i)) continue;
            COSObject paramsObj = stream.getKey(ASAtom.DECODE_PARMS);
            if (paramsObj.empty() || paramsObj.getType() == COSObjType.COS_NULL) {
                res = false;
                continue;
            }
            if (paramsObj.getType().isDictionaryBased() && (i != 0 || paramsObj.getNameKey(ASAtom.NAME) == ASAtom.IDENTITY)) {
                res = false;
                continue;
            }
            if (paramsObj.getType() == COSObjType.COS_ARRAY) {
                if (paramsObj.size() - 1 < i) {
                    res = false;
                    continue;
                }
                COSObject params = paramsObj.at(i);
                if (params == null || params.empty() || params.getType() == COSObjType.COS_NULL || params.getType().isDictionaryBased() && paramsObj.getNameKey(ASAtom.NAME) == ASAtom.IDENTITY) {
                    res = false;
                    continue;
                }
            }
            res = true;
        }
        return res;
    }

    public PDEncryption getPdEncryption() {
        return this.pdEncryption;
    }

    private byte[] getO() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getO());
    }

    private byte[] getU() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getU());
    }

    private byte[] getOE() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getOE());
    }

    private byte[] getUE() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getUE());
    }

    private byte[] getID() {
        COSObject id1;
        if (this.id != null && this.id.getType() == COSObjType.COS_ARRAY && (id1 = this.id.at(0)).getType() == COSObjType.COS_STRING) {
            return StandardSecurityHandler.getBytesOfHexString((COSString)id1.getDirectBase());
        }
        return null;
    }

    private static byte[] getBytesOfHexString(COSString s) {
        if (s == null) {
            return null;
        }
        return s.get();
    }

    private boolean isRC4Decryption() {
        if (this.pdEncryption.getV() >= 4) {
            return this.method != ASAtom.AESV3 && this.method != ASAtom.AESV2;
        }
        return true;
    }
}

