/*
 * Decompiled with CFR 0.152.
 */
package org.velmax.multipartdatabuilder;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class MultipartDataBuilder {
    private static final String LINE_FEED = "\r\n";
    HashMap<String, String> headersFields;
    HashMap<String, String> formFields;
    HashMap<String, BinaryField> formFiles;
    String charset;
    HttpURLConnection connection = null;
    String boundary;
    OutputStream outputStream = null;
    PrintWriter writer = null;

    public MultipartDataBuilder(HttpURLConnection connection, String charset) throws IOException {
        this.charset = charset;
        this.headersFields = new HashMap();
        this.formFields = new HashMap();
        this.formFiles = new HashMap();
        this.connection = connection;
    }

    private void prepareConnection() throws IOException {
        this.boundary = "***AndroidMultipartBoundary" + System.currentTimeMillis() + "***";
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setInstanceFollowRedirects(false);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public MultipartDataBuilder addHeaderField(String name, String value) {
        this.headersFields.put(name, value);
        return this;
    }

    public MultipartDataBuilder addFormField(String name, String value) {
        this.formFields.put(name, value);
        return this;
    }

    public MultipartDataBuilder addFormFile(String name, BinaryField file) {
        this.formFiles.put(name, file);
        return this;
    }

    public MultipartDataBuilder addFormFile(String name, File file, String fileName) {
        this.formFiles.put(name, new FileField(file, fileName));
        return this;
    }

    public MultipartDataBuilder addFormFile(String name, File file) {
        this.formFiles.put(name, new FileField(file));
        return this;
    }

    private void finalizeContent() throws IOException {
        this.writer.append("--").append(this.boundary).append("--").append(LINE_FEED);
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContent() throws IOException {
        this.outputStream = this.connection.getOutputStream();
        this.writer = new PrintWriter(this.outputStream);
        for (Map.Entry<String, String> entry : this.headersFields.entrySet()) {
            this.writer.append(entry.getKey()).append(": ").append(entry.getValue()).append(LINE_FEED);
        }
        for (Map.Entry<String, String> entry : this.formFields.entrySet()) {
            this.writer.append("--").append(this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: form-data; name=\"").append(entry.getKey()).append("\"").append(LINE_FEED);
            this.writer.append("Content-Type: text/plain; charset=").append(this.charset).append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.append(entry.getValue()).append(LINE_FEED);
        }
        for (Map.Entry<String, Object> entry : this.formFiles.entrySet()) {
            BinaryField binaryField = (BinaryField)entry.getValue();
            this.writer.append("--").append(this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: form-data; name=\"").append(entry.getKey()).append("\"; filename=\"").append(binaryField.getFileName()).append("\"").append(LINE_FEED);
            this.writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(binaryField.getFileName())).append(LINE_FEED);
            this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.flush();
            try (InputStream inputStream = binaryField.getStream();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    this.outputStream.write(buffer, 0, bytesRead);
                }
            }
            this.outputStream.flush();
            this.writer.append(LINE_FEED);
        }
        this.writer.flush();
    }

    public void build() throws IOException {
        try {
            this.prepareConnection();
            this.sendContent();
            this.finalizeContent();
        }
        finally {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }

    private static class FileField
    extends BinaryField {
        File file;

        public FileField(File file) {
            this(file, file.getName());
        }

        public FileField(File file, String name) {
            super(name);
            this.file = file;
        }

        @Override
        protected InputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }

    public static abstract class BinaryField
    implements Closeable {
        String fileName;
        InputStream stream;

        public BinaryField(String fileName) {
            this.setFileName(fileName);
        }

        public InputStream getStream() throws IOException {
            if (this.stream != null) {
                return this.stream;
            }
            this.stream = this.openStream();
            return this.stream;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String name) {
            this.fileName = name;
        }

        protected abstract InputStream openStream() throws IOException;

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }
}

