/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.spring.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotFailedException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobParametersNotFoundException;
import org.springframework.batch.core.launch.support.ExitCodeMapper;
import org.springframework.batch.core.launch.support.SimpleJvmExitCodeMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UnitilsCommandLineJobRunner {
    protected static final Log LOGGER = LogFactory.getLog(UnitilsCommandLineJobRunner.class);
    private ExitCodeMapper exitCodeMapper = new SimpleJvmExitCodeMapper();
    private JobLauncher launcher;
    private String message = "";
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private JobExplorer jobExplorer;
    private ApplicationContext context;

    public UnitilsCommandLineJobRunner(ApplicationContext context) {
        this.context = context;
        Collection jobLauncherValues = context.getBeansOfType(JobLauncher.class).values();
        if (jobLauncherValues.size() != 1) {
            throw new RuntimeException("The combined application context must contain only one instance of JobLauncher, instead there where " + jobLauncherValues.size());
        }
        this.launcher = (JobLauncher)jobLauncherValues.iterator().next();
        Collection jobExplorerValues = context.getBeansOfType(JobExplorer.class).values();
        if (jobExplorerValues.size() == 1) {
            this.jobExplorer = (JobExplorer)jobExplorerValues.iterator().next();
        } else if (jobExplorerValues.size() > 1) {
            throw new RuntimeException("The combined application context must contain only one instance of JobExplorer, instead there where " + jobExplorerValues.size());
        }
    }

    public int start(String jobIdentifier, String[] parameters, Set<String> opts) {
        try {
            Assert.state((this.launcher != null ? 1 : 0) != 0, (String)"A JobLauncher must be provided.  Please add one to the configuration.");
            if (opts.contains("-restart") || opts.contains("-next")) {
                Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer must be provided for a restart or start next operation.  Please add one to the configuration.");
            }
            String jobName = jobIdentifier;
            JobParameters jobParameters = this.jobParametersConverter.getJobParameters(StringUtils.splitArrayElementsIntoProperties((String[])parameters, (String)"="));
            Assert.isTrue((parameters == null || parameters.length == 0 || !jobParameters.isEmpty() ? 1 : 0) != 0, (String)("Invalid JobParameters " + Arrays.asList(parameters) + ". If parameters are provided they should be in the form name=value (no whitespace)."));
            if (opts.contains("-restart")) {
                JobExecution jobExecution = this.getLastFailedJobExecution(jobIdentifier);
                if (jobExecution == null) {
                    throw new JobExecutionNotFailedException("No failed or stopped execution found for job=" + jobIdentifier);
                }
                jobParameters = jobExecution.getJobInstance().getJobParameters();
                jobName = jobExecution.getJobInstance().getJobName();
            }
            Job job = (Job)this.context.getBean(jobName);
            if (opts.contains("-next")) {
                JobParameters nextParameters = this.getNextJobParameters(job);
                HashMap map = new HashMap(nextParameters.getParameters());
                map.putAll(jobParameters.getParameters());
                jobParameters = new JobParameters(map);
            }
            JobExecution jobExecution = this.launcher.run(job, jobParameters);
            return this.exitCodeMapper.intValue(jobExecution.getExitStatus().getExitCode());
        }
        catch (Exception e) {
            this.message = "Job Terminated in error: " + e.getMessage();
            LOGGER.error((Object)this.message, (Throwable)e);
            return this.exitCodeMapper.intValue(ExitStatus.FAILED.getExitCode());
        }
    }

    protected JobExecution getLastFailedJobExecution(String jobIdentifier) {
        JobExecution jobExecution;
        Long executionId = this.getLongIdentifier(jobIdentifier);
        if (executionId != null && (jobExecution = this.jobExplorer.getJobExecution(executionId)).getStatus().isGreaterThan(BatchStatus.STOPPING)) {
            return jobExecution;
        }
        int start = 0;
        int count = 100;
        List lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start, count);
        while (!lastInstances.isEmpty()) {
            for (JobInstance jobInstance : lastInstances) {
                JobExecution jobExecution2;
                List jobExecutions = this.jobExplorer.getJobExecutions(jobInstance);
                if (jobExecutions == null || jobExecutions.isEmpty() || !(jobExecution2 = (JobExecution)jobExecutions.get(jobExecutions.size() - 1)).getStatus().isGreaterThan(BatchStatus.STOPPING)) continue;
                return jobExecution2;
            }
            lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start += count, count);
        }
        return null;
    }

    private Long getLongIdentifier(String jobIdentifier) {
        try {
            return new Long(jobIdentifier);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected JobParameters getNextJobParameters(Job job) throws JobParametersNotFoundException {
        JobParameters jobParameters;
        String jobIdentifier = job.getName();
        List lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, 0, 1);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        if (incrementer == null) {
            throw new JobParametersNotFoundException("No job parameters incrementer found for job=" + jobIdentifier);
        }
        if (lastInstances.isEmpty()) {
            jobParameters = incrementer.getNext(new JobParameters());
            if (jobParameters == null) {
                throw new JobParametersNotFoundException("No bootstrap parameters found from incrementer for job=" + jobIdentifier);
            }
        } else {
            jobParameters = incrementer.getNext(((JobInstance)lastInstances.get(0)).getJobParameters());
        }
        return jobParameters;
    }

    public void setLauncher(JobLauncher launcher) {
        this.launcher = launcher;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public void setJobParametersConverter(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }
}

