/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.spring.batch;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.springframework.context.ApplicationContext;
import org.unitils.core.UnitilsException;
import org.unitils.spring.batch.BatchOption;
import org.unitils.spring.batch.BatchTest;
import org.unitils.spring.batch.UnitilsCommandLineJobRunner;

public class BatchTestImpl
implements BatchTest {
    private ApplicationContext context;
    private String jobName;
    private String parameter;
    private BatchOption option;
    private final int exitCode;

    public BatchTestImpl(ApplicationContext contextFile, String jobName, int exitCode) throws UnitilsException {
        this.jobName = jobName;
        this.context = contextFile;
        this.exitCode = exitCode;
    }

    public BatchTestImpl(ApplicationContext context, String jobName, String parameter, int exitCode) throws UnitilsException {
        this.jobName = jobName;
        this.context = context;
        this.parameter = parameter;
        this.exitCode = exitCode;
    }

    public BatchTestImpl(ApplicationContext context, String jobName, String parameter, BatchOption option, int exitCode) throws UnitilsException {
        this.jobName = jobName;
        this.context = context;
        this.parameter = parameter;
        this.exitCode = exitCode;
        this.option = option;
    }

    @Override
    public void launchJob() throws Exception {
        UnitilsCommandLineJobRunner runner = new UnitilsCommandLineJobRunner(this.context);
        String[] parameters = this.initParameters(this.parameter);
        Set<String> opts = this.initOpts();
        int result = runner.start(this.jobName, parameters, opts);
        Assert.assertEquals((String)"The batch exit code did not match", (long)this.exitCode, (long)result);
    }

    private String[] initParameters(String parametersToSplit) {
        if (parametersToSplit != null) {
            return StringUtils.split((String)parametersToSplit, (char)' ');
        }
        return new String[0];
    }

    private Set<String> initOpts() {
        HashSet<String> set = new HashSet<String>();
        if (this.option != null && !this.option.equals((Object)BatchOption.NONE)) {
            set.add(this.option.value());
        }
        return set;
    }
}

