/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.spring.batch;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.spring.SpringModule;
import org.unitils.spring.batch.BatchOption;
import org.unitils.spring.batch.BatchTest;
import org.unitils.spring.batch.BatchTestImpl;
import org.unitils.spring.batch.annotations.BatchTestEnvironment;
import org.unitils.spring.batch.annotations.BatchTestPlaceHolder;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class BatchModule
implements Module {
    private static final String PARAM_OPTION = "param=";
    private static final Log LOGGER = LogFactory.getLog(BatchModule.class);

    public void init(Properties configuration) {
        LOGGER.info((Object)"Batch module  : loaded");
    }

    protected void initializeBatchContext(Object testObject, Method testMethod) {
        this.fillupTestedObject(testObject, testMethod);
        this.fillupAnnotatedObjects(testObject);
    }

    protected void fillupAnnotatedObjects(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), BatchTestEnvironment.class);
        for (Field field : fields) {
            BatchTest value = this.createBatchJob(field, field.getAnnotation(BatchTestEnvironment.class), testObject);
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)value);
        }
    }

    protected void fillupTestedObject(Object testObject, Method testMethod) {
        BatchTestEnvironment annotation = testMethod.getAnnotation(BatchTestEnvironment.class);
        if (annotation == null) {
            return;
        }
        Field field = (Field)AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), BatchTestPlaceHolder.class).iterator().next();
        if (!field.getType().isAssignableFrom(BatchTest.class)) {
            throw new UnitilsException("When annotating the method with @BatchTestPlaceHolder a tested object from the type @BatchTest is expected");
        }
        BatchTest value = this.createBatchJob(field, annotation, testObject);
        ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)value);
    }

    protected BatchTest createBatchJob(Field field, BatchTestEnvironment annotation, Object testObject) {
        BatchTestImpl result = null;
        ApplicationContext contextFile = this.figureOutContext(annotation.contextFile(), testObject);
        String job = annotation.job();
        int exitCode = annotation.exitCode();
        BatchOption option = annotation.option();
        if (!StringUtils.isEmpty((String)annotation.jobParameters()) && annotation.jobParameters().contains("=") || annotation.parameter()) {
            String jobParameters = annotation.jobParameters();
            String parameter = "param==" + System.currentTimeMillis();
            if (StringUtils.isNotEmpty((String)jobParameters)) {
                parameter = parameter + " " + jobParameters;
            }
            parameter = parameter + " " + new Date().toString();
            result = option.equals((Object)BatchOption.NONE) ? new BatchTestImpl(contextFile, job, parameter, exitCode) : new BatchTestImpl(contextFile, job, parameter, option, exitCode);
        } else {
            result = option.equals((Object)BatchOption.NONE) ? new BatchTestImpl(contextFile, job, exitCode) : new BatchTestImpl(contextFile, job, null, option, exitCode);
        }
        return result;
    }

    protected ApplicationContext figureOutContext(String contextFile, Object testObject) {
        try {
            ClassPathXmlApplicationContext result = null;
            if (contextFile == null || contextFile.isEmpty()) {
                SpringModule mod = (SpringModule)Unitils.getInstance().getModulesRepository().getModulesOfType(SpringModule.class).get(0);
                result = mod.getApplicationContext(testObject);
            } else {
                result = new ClassPathXmlApplicationContext(contextFile);
            }
            return result;
        }
        catch (Exception e) {
            throw new UnitilsException("Plz fill in the contextFile in the BatchTestEnvironment annotation, or use the @SpringContext from the SpringModule of unitils. ", (Throwable)e);
        }
    }

    public void afterInit() {
    }

    public TestListener getTestListener() {
        return new BatchTestListener();
    }

    private class BatchTestListener
    extends TestListener {
        private BatchTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            super.beforeTestSetUp(testObject, testMethod);
            BatchModule.this.initializeBatchContext(testObject, testMethod);
        }
    }
}

