/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.SocketException;
import jline.Completor;
import jline.ConsoleReader;
import org.apache.maven.plugin.logging.Log;
import org.twdata.maven.cli.console.CliConsole;

public class JLineCliConsole
implements CliConsole {
    private final ConsoleReader consoleReader;
    private final Log logger;

    public JLineCliConsole(InputStream in, PrintStream out, Log logger, Completor completor, String prompt) {
        try {
            this.consoleReader = new ConsoleReader(in, new OutputStreamWriter(out));
            this.consoleReader.setBellEnabled(false);
            this.consoleReader.setDefaultPrompt(prompt + "> ");
            this.logger = logger;
            this.consoleReader.addCompletor(completor);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create reader to read commands.", ex);
        }
    }

    public String readLine() {
        try {
            return this.consoleReader.readLine();
        }
        catch (SocketException ex) {
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read command.", ex);
        }
    }

    public void writeInfo(String info) {
        this.logger.info((CharSequence)info);
    }

    public void writeError(String error) {
        this.logger.error((CharSequence)error);
    }

    public void writeDebug(String debug) {
        this.logger.debug((CharSequence)debug);
    }
}

