/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.twdata.maven.cli.commands.Command;
import org.twdata.maven.cli.console.CliConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliShell {
    private final List<Command> commands;
    private final CliConsole console;

    public CliShell(List<Command> commands, CliConsole console) {
        this.commands = commands;
        this.console = console;
    }

    public void run() {
        String line;
        this.console.writeInfo("Waiting for commands...");
        while ((line = this.console.readLine()) != null) {
            try {
                if (StringUtils.isEmpty((String)line) || this.interpretCommand(line.trim().replaceAll(" {2,}", " "))) continue;
                break;
            }
            catch (Exception ex) {
                StringWriter exMsg = new StringWriter();
                ex.printStackTrace(new PrintWriter(exMsg));
                this.console.writeError("Unable to complete running command: " + line + "\n" + exMsg.toString());
            }
        }
    }

    private boolean interpretCommand(String request) {
        for (Command command : this.commands) {
            if (!command.matchesRequest(request)) continue;
            return command.run(request, this.console);
        }
        this.console.writeError("Invalid command: " + request);
        return true;
    }
}

