/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class SimpleClassNameToken
implements Token {
    SimpleClassNameToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.CLASS);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        builder.append(SimpleClassNameToken.getSimpleClassName(logEntry.getClassName()));
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setString(index, SimpleClassNameToken.getSimpleClassName(logEntry.getClassName()));
    }

    private static String getSimpleClassName(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            return null;
        }
        int dotIndex = fullyQualifiedClassName.lastIndexOf(46);
        if (dotIndex < 0) {
            return fullyQualifiedClassName;
        }
        return fullyQualifiedClassName.substring(dotIndex + 1);
    }
}

