/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class LockedFileOutputStreamWriter
implements ByteArrayWriter {
    private final FileOutputStream stream;

    public LockedFileOutputStreamWriter(FileOutputStream stream) {
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] data, int length) throws IOException {
        FileChannel channel = this.stream.getChannel();
        FileLock lock = channel.lock();
        try {
            channel.position(channel.size());
            this.stream.write(data, 0, length);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

