/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.FormatPatternParser;
import org.tinylog.pattern.Token;
import org.tinylog.provider.InternalLogger;
import org.tinylog.writers.Writer;
import org.tinylog.writers.raw.BufferedWriterDecorator;
import org.tinylog.writers.raw.ByteArrayWriter;
import org.tinylog.writers.raw.LockedFileOutputStreamWriter;
import org.tinylog.writers.raw.OutputStreamWriter;
import org.tinylog.writers.raw.SynchronizedWriterDecorator;

public abstract class AbstractFormatPatternWriter
implements Writer {
    private static final String DEFAULT_FORMAT_PATTERN = "{date} [{thread}] {class}.{method}()\n{level}: {message}";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int BUILDER_CAPACITY = 1024;
    private final StringBuilder builder;
    private final Token token;

    public AbstractFormatPatternWriter(Map<String, String> properties) {
        String pattern = properties.get("format");
        if (pattern == null) {
            pattern = DEFAULT_FORMAT_PATTERN;
        }
        this.token = new FormatPatternParser(properties.get("exception")).parse(pattern + NEW_LINE);
        this.builder = Boolean.parseBoolean(properties.get("writingthread")) ? new StringBuilder(1024) : null;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return this.token.getRequiredLogEntryValues();
    }

    protected static String getFileName(Map<String, String> properties) {
        String fileName = properties.get("file");
        if (fileName == null) {
            throw new IllegalArgumentException("File name is missing for file writer");
        }
        return fileName;
    }

    protected static Charset getCharset(Map<String, String> properties) {
        String charsetName = properties.get("charset");
        try {
            return charsetName == null ? Charset.defaultCharset() : Charset.forName(charsetName);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log((Level)Level.ERROR, (String)("Invalid charset: " + charsetName));
            return Charset.defaultCharset();
        }
    }

    protected static ByteArrayWriter createByteArrayWriter(String fileName, boolean append, boolean buffered, boolean threadSafe, boolean shared) throws FileNotFoundException {
        ByteArrayWriter writer;
        File file = new File(fileName).getAbsoluteFile();
        file.getParentFile().mkdirs();
        FileOutputStream stream = new FileOutputStream(file, append);
        ByteArrayWriter byteArrayWriter = writer = shared ? new LockedFileOutputStreamWriter(stream) : new OutputStreamWriter(stream);
        if (buffered) {
            writer = new BufferedWriterDecorator(writer);
        }
        if (threadSafe) {
            writer = new SynchronizedWriterDecorator(writer, stream);
        }
        return writer;
    }

    protected final String render(LogEntry logEntry) {
        if (this.builder == null) {
            StringBuilder builder = new StringBuilder(1024);
            this.token.render(logEntry, builder);
            return builder.toString();
        }
        this.builder.setLength(0);
        this.token.render(logEntry, this.builder);
        return this.builder.toString();
    }
}

