/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.util.Collection;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.provider.InternalLogger;
import org.tinylog.writers.AbstractFormatPatternWriter;

public final class ConsoleWriter
extends AbstractFormatPatternWriter {
    private final Level errorLevel;

    public ConsoleWriter(Map<String, String> properties) {
        super(properties);
        String stream = properties.get("stream");
        if (stream == null) {
            this.errorLevel = Level.WARN;
        } else if ("err".equalsIgnoreCase(stream)) {
            this.errorLevel = Level.TRACE;
        } else if ("out".equalsIgnoreCase(stream)) {
            this.errorLevel = Level.OFF;
        } else {
            InternalLogger.log((Level)Level.ERROR, (String)("Stream must be \"out\" or \"err\", \"" + stream + "\" is an invalid stream name"));
            this.errorLevel = Level.WARN;
        }
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        Collection<LogEntryValue> logEntryValues = super.getRequiredLogEntryValues();
        logEntryValues.add(LogEntryValue.LEVEL);
        return logEntryValues;
    }

    @Override
    public void write(LogEntry logEntry) {
        if (logEntry.getLevel().ordinal() < this.errorLevel.ordinal()) {
            System.out.print(this.render(logEntry));
        } else {
            System.err.print(this.render(logEntry));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

