/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EnumSet;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.ExceptionToken;
import org.tinylog.pattern.MessageToken;
import org.tinylog.pattern.Token;

final class MessageAndExceptionToken
implements Token {
    private final MessageToken messageToken = new MessageToken();
    private final ExceptionToken exceptionToken = new ExceptionToken();

    MessageAndExceptionToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return EnumSet.of(LogEntryValue.MESSAGE, LogEntryValue.EXCEPTION);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        this.messageToken.render(logEntry, builder);
        if (logEntry.getException() != null) {
            if (logEntry.getMessage() != null) {
                builder.append(": ");
            }
            this.exceptionToken.render(logEntry, builder);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        if (logEntry.getException() == null) {
            statement.setString(index, logEntry.getMessage());
        } else {
            StringBuilder builder = new StringBuilder();
            this.render(logEntry, builder);
            statement.setString(index, builder.toString());
        }
    }
}

