/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.evaluator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.standard.resolver.StandardTestableResolver;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedData;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestFieldNaming;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestRawData;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.IStandardTestEvaluator;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.IStandardTestFieldEvaluator;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.StandardTestFieldEvaluationSpec;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;

public class StandardTestEvaluator
implements IStandardTestEvaluator {
    public static final String EVALUATOR_FIELD_QUALIFIER = "evaluator";

    @Override
    public StandardTestEvaluatedData evaluateTestData(String executionId, StandardTestRawData rawData, StandardTestableResolver resolver) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)rawData, (String)"Data cannot be null");
        StandardTestEvaluatedData data = new StandardTestEvaluatedData(rawData.getTestResource());
        Set<StandardTestFieldEvaluationSpec> fieldSpecSet = this.getFieldSpecSet();
        Map<String, StandardTestFieldEvaluationSpec> resolvedFieldSpecs = StandardTestEvaluator.resolveAndValidateFieldSpecs(rawData, fieldSpecSet);
        for (Map.Entry<String, StandardTestFieldEvaluationSpec> fieldEntry : resolvedFieldSpecs.entrySet()) {
            String fieldName = fieldEntry.getKey();
            StandardTestFieldEvaluationSpec fieldSpec = fieldEntry.getValue();
            IStandardTestFieldEvaluator evaluator = fieldSpec.getEvaluator();
            HashSet<String> fieldQualifiers = new HashSet<String>(rawData.getQualifiersForField(fieldName));
            if (!fieldQualifiers.contains(StandardTestFieldNaming.FIELD_QUALIFIER_MAIN)) {
                fieldQualifiers.add(StandardTestFieldNaming.FIELD_QUALIFIER_MAIN);
            }
            for (String fieldQualifier : fieldQualifiers) {
                if (fieldQualifier != null && EVALUATOR_FIELD_QUALIFIER.equals(fieldQualifier)) continue;
                StandardTestEvaluatedField evaluation = evaluator.getValue(executionId, rawData, resolver.getTestResourceResolver(), fieldName, fieldQualifier);
                if (evaluation != null && evaluation.hasNotNullValue()) {
                    Object value = evaluation.getValue();
                    Class<?> valueClass = fieldSpec.getEvaluator().getValueClass();
                    if (!valueClass.isAssignableFrom(value.getClass())) {
                        throw new TestEngineExecutionException("A value of class \"" + value.getClass().getName() + "\" resulted from evaluation of field \"" + fieldName + "\" in \"" + data.getTestResource().getName() + "\", but value was expected to be of class \"" + valueClass.getName() + "\"");
                    }
                }
                data.setValue(fieldName, fieldQualifier, evaluation);
            }
        }
        return data;
    }

    private static Map<String, StandardTestFieldEvaluationSpec> resolveAndValidateFieldSpecs(StandardTestRawData data, Set<StandardTestFieldEvaluationSpec> fieldSpecSet) {
        HashMap<String, StandardTestFieldEvaluationSpec> resolvedFieldSpecs = new HashMap<String, StandardTestFieldEvaluationSpec>();
        for (StandardTestFieldEvaluationSpec spec : fieldSpecSet) {
            resolvedFieldSpecs.put(spec.getName(), spec);
        }
        Set<String> fieldNames = data.getFieldNames();
        for (String fieldName : fieldNames) {
            if (!resolvedFieldSpecs.containsKey(fieldName)) {
                throw new TestEngineExecutionException("A field called \"" + fieldName + "\" has been found in \"" + data.getTestResource().getName() + "\", but test field specifications do not allow field \"" + fieldName + "\"");
            }
            String fieldEvaluatorValue = data.getValueForFieldAndQualifier(fieldName, EVALUATOR_FIELD_QUALIFIER);
            if (fieldEvaluatorValue == null) continue;
            StandardTestFieldEvaluationSpec newSpec = StandardTestEvaluator.initializeFieldSpec(data.getTestResource(), fieldName, fieldEvaluatorValue);
            resolvedFieldSpecs.put(fieldName, newSpec);
        }
        return resolvedFieldSpecs;
    }

    private static StandardTestFieldEvaluationSpec initializeFieldSpec(ITestResource resource, String fieldName, String fieldValue) {
        String className = fieldValue.trim();
        try {
            ClassLoader classLoader = ClassLoaderUtils.getClassLoader(StandardTestEvaluator.class);
            Class<?> evaluatorClass = classLoader.loadClass(className);
            if (!IStandardTestFieldEvaluator.class.isAssignableFrom(evaluatorClass)) {
                throw new TestEngineExecutionException("Specification found for field \"" + fieldName + "\" in \"" + resource.getName() + "\" selects class \"" + className + "\" as evaluator implementation. But this class does not implement the " + IStandardTestFieldEvaluator.class.getName() + " interface");
            }
            IStandardTestFieldEvaluator evaluatorResolver = (IStandardTestFieldEvaluator)evaluatorClass.newInstance();
            StandardTestFieldEvaluationSpec newSpec = new StandardTestFieldEvaluationSpec(fieldName, evaluatorResolver);
            return newSpec;
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Error while initializing evaluator for field \"" + fieldName + "\" in \"" + resource.getName() + "\"", t);
        }
    }

    protected Set<StandardTestFieldEvaluationSpec> getFieldSpecSet() {
        return StandardTestFieldEvaluationSpec.STANDARD_TEST_FIELD_SPECS;
    }
}

