/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.spring5.context.webmvc.SpringWebMvcThymeleafRequestContext;
import org.thymeleaf.spring5.expression.ThymeleafEvaluationContext;
import org.thymeleaf.testing.templateengine.context.web.ISpringVersionSpecificContextInitializer;

final class Spring5VersionSpecificContextInitializer
implements ISpringVersionSpecificContextInitializer {
    Spring5VersionSpecificContextInitializer() {
    }

    @Override
    public void versionSpecificAdditionalVariableProcessing(ApplicationContext applicationContext, ConversionService conversionService, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Map<String, Object> variables) {
        RequestContext requestContext = (RequestContext)variables.get("springMacroRequestContext");
        variables.put("springRequestContext", requestContext);
        SpringWebMvcThymeleafRequestContext thymeleafRequestContext = new SpringWebMvcThymeleafRequestContext(requestContext, request);
        variables.put("thymeleafRequestContext", thymeleafRequestContext);
        ThymeleafEvaluationContext evaluationContext = new ThymeleafEvaluationContext(applicationContext, conversionService);
        variables.put("thymeleaf::EvaluationContext", evaluationContext);
    }

    @Override
    public IWebContext versionSpecificCreateContextInstance(ApplicationContext applicationContext, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        return new WebContext(request, response, servletContext, locale, variables);
    }
}

