/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceItem;
import org.thymeleaf.testing.templateengine.standard.resolver.StandardTestableResolver;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestRawData;
import org.thymeleaf.testing.templateengine.standard.test.reader.IStandardTestReader;
import org.thymeleaf.util.Validate;

public class StandardTestReader
implements IStandardTestReader {
    public static final char COMMENT_PREFIX_CHAR = '#';
    public static final char FIELD_PREFIX_CHAR = '%';
    public static final Pattern FIELD_DEFINITION_PATTERN = Pattern.compile("([\\p{Alnum}_-]*)(\\[(\\S*)\\])?");
    public static final int FIELD_NAME_GROUP = 1;
    public static final int FIELD_QUALIFIER_GROUP = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardTestRawData readTestResource(String executionId, ITestResource resource, StandardTestableResolver resolver) throws IOException {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)resource, (String)"Resource cannot be null");
        if (!(resource instanceof ITestResourceItem)) {
            throw new TestEngineExecutionException("Document resource specified for test \"" + resource.getName() + "\" which is a container, not an item " + "(maybe a folder?)");
        }
        String resourceContents = ((ITestResourceItem)resource).readAsText();
        BufferedReader r = new BufferedReader(new StringReader(resourceContents));
        StandardTestRawData data = new StandardTestRawData(resource);
        try {
            String currentFieldName = null;
            String currentFieldQualifier = null;
            StringBuilder strBuilder = null;
            boolean builderContainsSomething = false;
            String line = r.readLine();
            while (line != null) {
                int valueStart;
                if (this.isCommentLine(line)) {
                    line = r.readLine();
                    continue;
                }
                String newFieldDefinition = StandardTestReader.extractFieldDefinition(line);
                if (newFieldDefinition == null) {
                    if (currentFieldName == null) {
                        line = r.readLine();
                        continue;
                    }
                    if (strBuilder != null) {
                        if (builderContainsSomething) {
                            strBuilder.append('\n');
                        }
                        strBuilder.append(line);
                        builderContainsSomething = true;
                    }
                    line = r.readLine();
                    continue;
                }
                if (currentFieldName != null && strBuilder != null) {
                    data.setValue(currentFieldName, currentFieldQualifier, strBuilder.toString());
                }
                int lineLen = line.length();
                currentFieldName = StandardTestReader.extractFieldName(newFieldDefinition);
                currentFieldQualifier = StandardTestReader.extractFieldQualifier(newFieldDefinition);
                strBuilder = new StringBuilder();
                builderContainsSomething = false;
                if (newFieldDefinition.length() + 1 < lineLen - 1 && (valueStart = newFieldDefinition.length() + 1) < lineLen - 1) {
                    strBuilder.append(line.substring(valueStart));
                    builderContainsSomething = true;
                }
                line = r.readLine();
            }
            if (currentFieldName != null && strBuilder != null) {
                data.setValue(currentFieldName, currentFieldQualifier, strBuilder.toString());
            }
        }
        finally {
            try {
                r.close();
            }
            catch (Throwable throwable) {}
        }
        return data;
    }

    protected boolean isCommentLine(String line) {
        return line.length() > 0 && line.charAt(0) == '#';
    }

    private static String extractFieldDefinition(String line) {
        int i;
        int lineLen = line.length();
        if (lineLen <= 0) {
            return null;
        }
        char c = line.charAt(0);
        if (c != '%') {
            return null;
        }
        for (i = 1; i < lineLen && !Character.isWhitespace(c = line.charAt(i)); ++i) {
        }
        String tentativeFieldDefinition = line.substring(1, i);
        return StandardTestReader.isFieldDefinition(tentativeFieldDefinition) ? tentativeFieldDefinition : null;
    }

    private static boolean isFieldDefinition(String name) {
        if (name == null) {
            return false;
        }
        Matcher m = FIELD_DEFINITION_PATTERN.matcher(name);
        return m.matches();
    }

    private static String extractFieldName(String fieldDefinition) {
        if (fieldDefinition == null) {
            return null;
        }
        Matcher m = FIELD_DEFINITION_PATTERN.matcher(fieldDefinition);
        if (!m.matches()) {
            return null;
        }
        String name = m.group(1);
        if (name == null || name.trim().equals("")) {
            return null;
        }
        return name.trim();
    }

    private static String extractFieldQualifier(String fieldDefinition) {
        if (fieldDefinition == null) {
            return null;
        }
        Matcher m = FIELD_DEFINITION_PATTERN.matcher(fieldDefinition);
        if (!m.matches()) {
            return null;
        }
        String qualifier = m.group(3);
        if (qualifier == null || qualifier.trim().equals("")) {
            return null;
        }
        return qualifier.trim();
    }
}

